# Generated by default/object.tt
package Paws::GlueDataBrew::Project;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has CreateDate => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Str');
  has DatasetName => (is => 'ro', isa => 'Str');
  has LastModifiedBy => (is => 'ro', isa => 'Str');
  has LastModifiedDate => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has OpenDate => (is => 'ro', isa => 'Str');
  has OpenedBy => (is => 'ro', isa => 'Str');
  has RecipeName => (is => 'ro', isa => 'Str', required => 1);
  has ResourceArn => (is => 'ro', isa => 'Str');
  has RoleArn => (is => 'ro', isa => 'Str');
  has Sample => (is => 'ro', isa => 'Paws::GlueDataBrew::Sample');
  has Tags => (is => 'ro', isa => 'Paws::GlueDataBrew::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::Project

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::Project object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::Project object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Represents all of the attributes of a DataBrew project.

=head1 ATTRIBUTES


=head2 AccountId => Str

The ID of the Amazon Web Services account that owns the project.


=head2 CreateDate => Str

The date and time that the project was created.


=head2 CreatedBy => Str

The Amazon Resource Name (ARN) of the user who crated the project.


=head2 DatasetName => Str

The dataset that the project is to act upon.


=head2 LastModifiedBy => Str

The Amazon Resource Name (ARN) of the user who last modified the
project.


=head2 LastModifiedDate => Str

The last modification date and time for the project.


=head2 B<REQUIRED> Name => Str

The unique name of a project.


=head2 OpenDate => Str

The date and time when the project was opened.


=head2 OpenedBy => Str

The Amazon Resource Name (ARN) of the user that opened the project for
use.


=head2 B<REQUIRED> RecipeName => Str

The name of a recipe that will be developed during a project session.


=head2 ResourceArn => Str

The Amazon Resource Name (ARN) for the project.


=head2 RoleArn => Str

The Amazon Resource Name (ARN) of the role that will be assumed for
this project.


=head2 Sample => L<Paws::GlueDataBrew::Sample>

The sample size and sampling type to apply to the data. If this
parameter isn't specified, then the sample consists of the first 500
rows from the dataset.


=head2 Tags => L<Paws::GlueDataBrew::TagMap>

Metadata tags that have been applied to the project.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

