# Generated by default/object.tt
package Paws::Glue::LineageConfiguration;
  use Moose;
  has CrawlerLineageSettings => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::LineageConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::LineageConfiguration object:

  $service_obj->Method(Att1 => { CrawlerLineageSettings => $value, ..., CrawlerLineageSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::LineageConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CrawlerLineageSettings

=head1 DESCRIPTION

Specifies data lineage configuration settings for the crawler.

=head1 ATTRIBUTES


=head2 CrawlerLineageSettings => Str

Specifies whether data lineage is enabled for the crawler. Valid values
are:

=over

=item *

ENABLE: enables data lineage for the crawler

=item *

DISABLE: disables data lineage for the crawler

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

