# Generated by default/object.tt
package Paws::GameLift::GameServer;
  use Moose;
  has ClaimStatus => (is => 'ro', isa => 'Str');
  has ConnectionInfo => (is => 'ro', isa => 'Str');
  has GameServerData => (is => 'ro', isa => 'Str');
  has GameServerGroupArn => (is => 'ro', isa => 'Str');
  has GameServerGroupName => (is => 'ro', isa => 'Str');
  has GameServerId => (is => 'ro', isa => 'Str');
  has InstanceId => (is => 'ro', isa => 'Str');
  has LastClaimTime => (is => 'ro', isa => 'Str');
  has LastHealthCheckTime => (is => 'ro', isa => 'Str');
  has RegistrationTime => (is => 'ro', isa => 'Str');
  has UtilizationStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::GameServer

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::GameServer object:

  $service_obj->Method(Att1 => { ClaimStatus => $value, ..., UtilizationStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::GameServer object:

  $result = $service_obj->Method(...);
  $result->Att1->ClaimStatus

=head1 DESCRIPTION

B<This data type is used with the GameLift FleetIQ and game server
groups.>

Properties describing a game server that is running on an instance in a
GameServerGroup.

A game server is created by a successful call to C<RegisterGameServer>
and deleted by calling C<DeregisterGameServer>. A game server is
claimed to host a game session by calling C<ClaimGameServer>.

B<Related actions>

RegisterGameServer | ListGameServers | ClaimGameServer |
DescribeGameServer | UpdateGameServer | DeregisterGameServer | All APIs
by task
(https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html)

=head1 ATTRIBUTES


=head2 ClaimStatus => Str

Indicates when an available game server has been reserved for gameplay
but has not yet started hosting a game. Once it is claimed, the game
server remains in C<CLAIMED> status for a maximum of one minute. During
this time, game clients connect to the game server to start the game
and trigger the game server to update its utilization status. After one
minute, the game server claim status reverts to null.


=head2 ConnectionInfo => Str

The port and IP address that must be used to establish a client
connection to the game server.


=head2 GameServerData => Str

A set of custom game server properties, formatted as a single string
value. This data is passed to a game client or service when it requests
information on game servers using ListGameServers or ClaimGameServer.


=head2 GameServerGroupArn => Str

The ARN identifier for the game server group where the game server is
located.


=head2 GameServerGroupName => Str

A unique identifier for the game server group where the game server is
running. Use either the GameServerGroup name or ARN value.


=head2 GameServerId => Str

A custom string that uniquely identifies the game server. Game server
IDs are developer-defined and are unique across all game server groups
in an AWS account.


=head2 InstanceId => Str

The unique identifier for the instance where the game server is
running. This ID is available in the instance metadata. EC2 instance
IDs use a 17-character format, for example: C<i-1234567890abcdef0>.


=head2 LastClaimTime => Str

Timestamp that indicates the last time the game server was claimed with
a ClaimGameServer request. The format is a number expressed in Unix
time as milliseconds (for example C<"1469498468.057">). This value is
used to calculate when a claimed game server's status should revert to
null.


=head2 LastHealthCheckTime => Str

Timestamp that indicates the last time the game server was updated with
health status using an UpdateGameServer request. The format is a number
expressed in Unix time as milliseconds (for example
C<"1469498468.057">). After game server registration, this property is
only changed when a game server update specifies a health check value.


=head2 RegistrationTime => Str

Timestamp that indicates when the game server was created with a
RegisterGameServer request. The format is a number expressed in Unix
time as milliseconds (for example C<"1469498468.057">).


=head2 UtilizationStatus => Str

Indicates whether the game server is currently available for new games
or is busy. Possible statuses include:

=over

=item *

C<AVAILABLE> - The game server is available to be claimed. A game
server that has been claimed remains in this status until it reports
game hosting activity.

=item *

C<UTILIZED> - The game server is currently hosting a game session with
players.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

