# Generated by default/object.tt
package Paws::ECRPublic::RegistryAlias;
  use Moose;
  has DefaultRegistryAlias => (is => 'ro', isa => 'Bool', request_name => 'defaultRegistryAlias', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has PrimaryRegistryAlias => (is => 'ro', isa => 'Bool', request_name => 'primaryRegistryAlias', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECRPublic::RegistryAlias

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECRPublic::RegistryAlias object:

  $service_obj->Method(Att1 => { DefaultRegistryAlias => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECRPublic::RegistryAlias object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultRegistryAlias

=head1 DESCRIPTION

An object representing the aliases for a public registry. A public
registry is given an alias upon creation but a custom alias can be set
using the Amazon ECR console. For more information, see Registries
(https://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html)
in the I<Amazon Elastic Container Registry User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DefaultRegistryAlias => Bool

Whether or not the registry alias is the default alias for the
registry. When the first public repository is created, your public
registry is assigned a default registry alias.


=head2 B<REQUIRED> Name => Str

The name of the registry alias.


=head2 B<REQUIRED> PrimaryRegistryAlias => Bool

Whether or not the registry alias is the primary alias for the
registry. If true, the alias is the primary registry alias and is
displayed in both the repository URL and the image URI used in the
C<docker pull> commands on the Amazon ECR Public Gallery.

A registry alias that is not the primary registry alias can be used in
the repository URI in a C<docker pull> command.


=head2 B<REQUIRED> Status => Str

The status of the registry alias.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECRPublic>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

