# Generated by default/object.tt
package Paws::ComputeOptimizer::VolumeRecommendationOption;
  use Moose;
  has Configuration => (is => 'ro', isa => 'Paws::ComputeOptimizer::VolumeConfiguration', request_name => 'configuration', traits => ['NameInRequest']);
  has PerformanceRisk => (is => 'ro', isa => 'Num', request_name => 'performanceRisk', traits => ['NameInRequest']);
  has Rank => (is => 'ro', isa => 'Int', request_name => 'rank', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::VolumeRecommendationOption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::VolumeRecommendationOption object:

  $service_obj->Method(Att1 => { Configuration => $value, ..., Rank => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::VolumeRecommendationOption object:

  $result = $service_obj->Method(...);
  $result->Att1->Configuration

=head1 DESCRIPTION

Describes a recommendation option for an Amazon Elastic Block Store
(Amazon EBS) instance.

=head1 ATTRIBUTES


=head2 Configuration => L<Paws::ComputeOptimizer::VolumeConfiguration>

An array of objects that describe a volume configuration.


=head2 PerformanceRisk => Num

The performance risk of the volume recommendation option.

Performance risk is the likelihood of the recommended volume type
meeting the performance requirement of your workload.

The value ranges from C<0> to C<5>, with C<0> meaning that the
recommended resource is predicted to always provide enough hardware
capability. The higher the performance risk is, the more likely you
should validate whether the recommendation will meet the performance
requirements of your workload before migrating your resource.


=head2 Rank => Int

The rank of the volume recommendation option.

The top recommendation option is ranked as C<1>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

