# Generated by default/object.tt
package Paws::CloudTrail::AdvancedEventSelector;
  use Moose;
  has FieldSelectors => (is => 'ro', isa => 'ArrayRef[Paws::CloudTrail::AdvancedFieldSelector]', required => 1);
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudTrail::AdvancedEventSelector

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudTrail::AdvancedEventSelector object:

  $service_obj->Method(Att1 => { FieldSelectors => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudTrail::AdvancedEventSelector object:

  $result = $service_obj->Method(...);
  $result->Att1->FieldSelectors

=head1 DESCRIPTION

Advanced event selectors let you create fine-grained selectors for the
following AWS CloudTrail event record elds. They help you control costs
by logging only those events that are important to you. For more
information about advanced event selectors, see Logging data events for
trails
(https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
in the I<AWS CloudTrail User Guide>.

=over

=item *

C<readOnly>

=item *

C<eventSource>

=item *

C<eventName>

=item *

C<eventCategory>

=item *

C<resources.type>

=item *

C<resources.ARN>

=back

You cannot apply both event selectors and advanced event selectors to a
trail.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FieldSelectors => ArrayRef[L<Paws::CloudTrail::AdvancedFieldSelector>]

Contains all selector statements in an advanced event selector.


=head2 Name => Str

An optional, descriptive name for an advanced event selector, such as
"Log data events for only two S3 buckets".



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudTrail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

