# Generated by default/object.tt
package Paws::Chime::AppInstance;
  use Moose;
  has AppInstanceArn => (is => 'ro', isa => 'Str');
  has CreatedTimestamp => (is => 'ro', isa => 'Str');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has Metadata => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::AppInstance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::AppInstance object:

  $service_obj->Method(Att1 => { AppInstanceArn => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::AppInstance object:

  $result = $service_obj->Method(...);
  $result->Att1->AppInstanceArn

=head1 DESCRIPTION

The details of an C<AppInstance>, an instance of an Amazon Chime SDK
messaging application.

=head1 ATTRIBUTES


=head2 AppInstanceArn => Str

The ARN of the messaging instance.


=head2 CreatedTimestamp => Str

The time at which an C<AppInstance> was created. In epoch milliseconds.


=head2 LastUpdatedTimestamp => Str

The time an C<AppInstance> was last updated. In epoch milliseconds.


=head2 Metadata => Str

The metadata of an C<AppInstance>.


=head2 Name => Str

The name of an C<AppInstance>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

