# Generated by default/object.tt
package Paws::AuditManager::ControlMappingSource;
  use Moose;
  has SourceDescription => (is => 'ro', isa => 'Str', request_name => 'sourceDescription', traits => ['NameInRequest']);
  has SourceFrequency => (is => 'ro', isa => 'Str', request_name => 'sourceFrequency', traits => ['NameInRequest']);
  has SourceId => (is => 'ro', isa => 'Str', request_name => 'sourceId', traits => ['NameInRequest']);
  has SourceKeyword => (is => 'ro', isa => 'Paws::AuditManager::SourceKeyword', request_name => 'sourceKeyword', traits => ['NameInRequest']);
  has SourceName => (is => 'ro', isa => 'Str', request_name => 'sourceName', traits => ['NameInRequest']);
  has SourceSetUpOption => (is => 'ro', isa => 'Str', request_name => 'sourceSetUpOption', traits => ['NameInRequest']);
  has SourceType => (is => 'ro', isa => 'Str', request_name => 'sourceType', traits => ['NameInRequest']);
  has TroubleshootingText => (is => 'ro', isa => 'Str', request_name => 'troubleshootingText', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::ControlMappingSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::ControlMappingSource object:

  $service_obj->Method(Att1 => { SourceDescription => $value, ..., TroubleshootingText => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::ControlMappingSource object:

  $result = $service_obj->Method(...);
  $result->Att1->SourceDescription

=head1 DESCRIPTION

The data source that determines from where AWS Audit Manager collects
evidence for the control.

=head1 ATTRIBUTES


=head2 SourceDescription => Str

The description of the specified source.


=head2 SourceFrequency => Str

The frequency of evidence collection for the specified control mapping
source.


=head2 SourceId => Str

The unique identifier for the specified source.


=head2 SourceKeyword => L<Paws::AuditManager::SourceKeyword>




=head2 SourceName => Str

The name of the specified source.


=head2 SourceSetUpOption => Str

The setup option for the data source, which reflects if the evidence
collection is automated or manual.


=head2 SourceType => Str

Specifies one of the five types of data sources for evidence
collection.


=head2 TroubleshootingText => Str

The instructions for troubleshooting the specified control.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

