# Generated by default/object.tt
package Paws::AmplifyBackend::BackendAPIAppSyncAuthSettings;
  use Moose;
  has CognitoUserPoolId => (is => 'ro', isa => 'Str', request_name => 'cognitoUserPoolId', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has ExpirationTime => (is => 'ro', isa => 'Num', request_name => 'expirationTime', traits => ['NameInRequest']);
  has OpenIDAuthTTL => (is => 'ro', isa => 'Str', request_name => 'openIDAuthTTL', traits => ['NameInRequest']);
  has OpenIDClientId => (is => 'ro', isa => 'Str', request_name => 'openIDClientId', traits => ['NameInRequest']);
  has OpenIDIatTTL => (is => 'ro', isa => 'Str', request_name => 'openIDIatTTL', traits => ['NameInRequest']);
  has OpenIDIssueURL => (is => 'ro', isa => 'Str', request_name => 'openIDIssueURL', traits => ['NameInRequest']);
  has OpenIDProviderName => (is => 'ro', isa => 'Str', request_name => 'openIDProviderName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::BackendAPIAppSyncAuthSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::BackendAPIAppSyncAuthSettings object:

  $service_obj->Method(Att1 => { CognitoUserPoolId => $value, ..., OpenIDProviderName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::BackendAPIAppSyncAuthSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->CognitoUserPoolId

=head1 DESCRIPTION

The authentication settings for accessing provisioned data models in
your Amplify project.

=head1 ATTRIBUTES


=head2 CognitoUserPoolId => Str

The Amazon Cognito user pool ID, if Amazon Cognito was used as an
authentication setting to access your data models.


=head2 Description => Str

The API key description for API_KEY, if it was used as an
authentication mechanism to access your data models.


=head2 ExpirationTime => Num

The API key expiration time for API_KEY, if it was used as an
authentication mechanism to access your data models.


=head2 OpenIDAuthTTL => Str

The expiry time for the OpenID authentication mechanism.


=head2 OpenIDClientId => Str

The clientID for openID, if openID was used as an authentication
setting to access your data models.


=head2 OpenIDIatTTL => Str

The expiry time for the OpenID authentication mechanism.


=head2 OpenIDIssueURL => Str

The openID issuer URL, if openID was used as an authentication setting
to access your data models.


=head2 OpenIDProviderName => Str

The OpenID provider name, if OpenID was used as an authentication
mechanism to access your data models.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

