# Generated by default/object.tt
package Paws::AccessAnalyzer::FindingSource;
  use Moose;
  has Detail => (is => 'ro', isa => 'Paws::AccessAnalyzer::FindingSourceDetail', request_name => 'detail', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::FindingSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::FindingSource object:

  $service_obj->Method(Att1 => { Detail => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::FindingSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Detail

=head1 DESCRIPTION

The source of the finding. This indicates how the access that generated
the finding is granted. It is populated for Amazon S3 bucket findings.

=head1 ATTRIBUTES


=head2 Detail => L<Paws::AccessAnalyzer::FindingSourceDetail>

Includes details about how the access that generated the finding is
granted. This is populated for Amazon S3 bucket findings.


=head2 B<REQUIRED> Type => Str

Indicates the type of access that generated the finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

