# Generated by default/object.tt
package Paws::ACMPCA::Qualifier;
  use Moose;
  has CpsUri => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::Qualifier

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::Qualifier object:

  $service_obj->Method(Att1 => { CpsUri => $value, ..., CpsUri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::Qualifier object:

  $result = $service_obj->Method(...);
  $result->Att1->CpsUri

=head1 DESCRIPTION

Defines a C<PolicyInformation> qualifier. ACM Private CA supports the
certification practice statement (CPS) qualifier
(https://tools.ietf.org/html/rfc5280#section-4.2.1.4) defined in RFC
5280.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CpsUri => Str

Contains a pointer to a certification practice statement (CPS)
published by the CA.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

