/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.tree.util.FastStringBuffer;

public class NumberFormatter
implements Serializable {
    private ArrayList formatTokens;
    private ArrayList punctuationTokens;
    private boolean startsWithPunctuation;

    public void prepare(String format) {
        if (format.length() == 0) {
            format = "1";
        }
        this.formatTokens = new ArrayList(10);
        this.punctuationTokens = new ArrayList(10);
        int len = format.length();
        int i = 0;
        boolean first = true;
        this.startsWithPunctuation = true;
        while (i < len) {
            int c = format.charAt(i);
            int t = i++;
            if (UTF16CharacterSet.isHighSurrogate(c)) {
                c = UTF16CharacterSet.combinePair((char)c, format.charAt(i));
            }
            while (NumberFormatter.isLetterOrDigit(c) && ++i != len) {
                c = format.charAt(i);
                if (!UTF16CharacterSet.isHighSurrogate(c)) continue;
                c = UTF16CharacterSet.combinePair((char)c, format.charAt(++i));
            }
            if (i > t) {
                String tok = format.substring(t, i);
                this.formatTokens.add(tok);
                if (first) {
                    this.punctuationTokens.add(".");
                    this.startsWithPunctuation = false;
                    first = false;
                }
            }
            if (i == len) break;
            t = i;
            c = format.charAt(i);
            if (UTF16CharacterSet.isHighSurrogate(c)) {
                c = UTF16CharacterSet.combinePair((char)c, format.charAt(++i));
            }
            while (!NumberFormatter.isLetterOrDigit(c)) {
                first = false;
                if (++i == len) break;
                c = format.charAt(i);
                if (!UTF16CharacterSet.isHighSurrogate(c)) continue;
                c = UTF16CharacterSet.combinePair((char)c, format.charAt(++i));
            }
            if (i <= t) continue;
            String sep = format.substring(t, i);
            this.punctuationTokens.add(sep);
        }
        if (this.formatTokens.isEmpty()) {
            this.formatTokens.add("1");
            if (this.punctuationTokens.size() == 1) {
                this.punctuationTokens.add(this.punctuationTokens.get(0));
            }
        }
    }

    private static boolean isLetterOrDigit(int c) {
        if (c <= 127) {
            return c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122;
        }
        return Alphanumeric.isAlphanumeric(c);
    }

    public CharSequence format(List numbers, int groupSize, String groupSeparator, String letterValue, String ordinal, Numberer numberer) {
        FastStringBuffer sb = new FastStringBuffer(16);
        int num = 0;
        int tok = 0;
        if (this.startsWithPunctuation) {
            sb.append((String)this.punctuationTokens.get(tok));
        }
        while (num < numbers.size()) {
            String s;
            Object o;
            if (num > 0) {
                if (tok == 0 && this.startsWithPunctuation) {
                    sb.append(".");
                } else {
                    sb.append((String)this.punctuationTokens.get(tok));
                }
            }
            if ((o = numbers.get(num++)) instanceof Long) {
                long nr = (Long)o;
                RegularGroupFormatter rgf = new RegularGroupFormatter(groupSize, groupSeparator, "");
                s = numberer.format(nr, (String)this.formatTokens.get(tok), rgf, letterValue, ordinal);
            } else {
                s = o.toString();
            }
            sb.append(s);
            if (++tok != this.formatTokens.size()) continue;
            --tok;
        }
        if (this.punctuationTokens.size() > this.formatTokens.size()) {
            sb.append((String)this.punctuationTokens.get(this.punctuationTokens.size() - 1));
        }
        return sb.condense();
    }
}

