/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.ObjectCacheHashMap;

public class TextCache
extends DataFileCache {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    protected String header;
    protected Table table;
    private ObjectCacheHashMap uncommittedCache;

    TextCache(Table table, String string) throws HsqlException {
        super(table.database, string, null);
        this.table = table;
        this.uncommittedCache = new ObjectCacheHashMap(5);
    }

    protected void initParams() throws HsqlException {
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(this.fileName, "=", ";", null);
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                throw Trace.error(75, 172);
            }
            case 1: {
                this.fileName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Trace.error(75, 173, hsqlProperties.errorKeys[1]);
            }
        }
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        this.fs = this.translateSep(hsqlProperties.getProperty("fs", hsqlDatabaseProperties.getProperty("textdb.fs", ",")));
        this.vs = this.translateSep(hsqlProperties.getProperty("vs", hsqlDatabaseProperties.getProperty("textdb.vs", this.fs)));
        this.lvs = this.translateSep(hsqlProperties.getProperty("lvs", hsqlDatabaseProperties.getProperty("textdb.lvs", this.fs)));
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Trace.error(75, 174);
        }
        this.ignoreFirst = hsqlProperties.isPropertyTrue("ignore_first", hsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first", false));
        this.isQuoted = hsqlProperties.isPropertyTrue("quoted", hsqlDatabaseProperties.isPropertyTrue("textdb.quoted", true));
        this.isAllQuoted = hsqlProperties.isPropertyTrue("all_quoted", hsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted", false));
        this.stringEncoding = this.translateSep(hsqlProperties.getProperty("encoding", hsqlDatabaseProperties.getProperty("textdb.encoding", "ASCII")));
        int n = hsqlProperties.getIntegerProperty("cache_scale", hsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale", 10, 8, 16));
        int n2 = hsqlProperties.getIntegerProperty("cache_size_scale", hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale", 10, 8, 20));
        int n3 = 1 << n;
        int n4 = 1 << n2;
        this.maxCacheSize = n3 * 3;
        this.maxCacheBytes = this.maxCacheSize * n4;
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    protected void initBuffers() {
        if (this.isQuoted || this.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
            this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
        }
    }

    private String translateSep(String string) {
        return this.translateSep(string, false);
    }

    private String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = 0;
        n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4);
            do {
                stringBuffer.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuffer.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuffer.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuffer.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuffer.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuffer.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuffer.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuffer.append('\'');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuffer.append(cArray, n2, n4 - n2);
            string = stringBuffer.toString();
        }
        return string;
    }

    public void open(boolean bl) throws HsqlException {
        this.fileFreePosition = 0L;
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.fileName, bl, 0, null, null);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw new IOException();
            }
            this.initBuffers();
        }
        catch (Exception exception) {
            throw Trace.error(29, 188, new Object[]{this.fileName, exception});
        }
        this.cacheReadonly = bl;
    }

    void reopen() throws HsqlException {
        this.open(this.cacheReadonly);
    }

    public void close(boolean bl) throws HsqlException {
        if (this.dataFile == null) {
            return;
        }
        try {
            this.cache.saveAll();
            boolean bl2 = this.dataFile.length() <= (long)NL.length();
            this.dataFile.close();
            this.dataFile = null;
            if (bl2 && !this.cacheReadonly) {
                FileUtil.delete(this.fileName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 189, new Object[]{this.fileName, exception});
        }
    }

    void purge() throws HsqlException {
        this.uncommittedCache.clear();
        try {
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.delete(this.fileName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 190, new Object[]{this.fileName, exception});
        }
    }

    public void remove(int n, PersistentStore persistentStore) throws HsqlException {
        CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(n);
        if (cachedObject != null) {
            return;
        }
        cachedObject = this.get(n, persistentStore, false);
        int n2 = cachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
        this.rowOut.reset();
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
        try {
            hsqlByteArrayOutputStream.fill(32, n2);
            hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
            this.dataFile.seek(n);
            this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException.toString());
        }
        this.release(cachedObject.getPos());
    }

    protected RowInputInterface readObject(int n) throws IOException {
        int n2;
        ByteArray byteArray = new ByteArray(80);
        boolean bl = true;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = n;
        RowInputText rowInputText = (RowInputText)this.rowIn;
        try {
            int n5 = 0;
            n = this.findNextUsedLinePos(n);
            if (n == -1) {
                return null;
            }
            this.dataFile.seek(n);
            while (true) {
                if ((n2 = this.dataFile.read()) == -1) {
                    if (byteArray.length() > 0) {
                        boolean bl3 = bl2 = !bl;
                        if (!this.cacheReadonly) {
                            this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                        }
                    }
                    break;
                }
                if (n3 == 0 && n2 == 34 && (this.isQuoted || this.isAllQuoted)) {
                    ++n5;
                }
                if (n5 % 2 == 0) {
                    if (n3 == 1 || n2 == 10) {
                        if (this.ignoreFirst && n == 0) {
                            this.header = byteArray.toString();
                            bl = true;
                        }
                        if (n2 == 10) {
                            ++n3;
                        }
                        if (bl) {
                            n += byteArray.length() + n3;
                            byteArray.setLength(0);
                            rowInputText.skippedLine();
                            continue;
                        }
                        bl2 = true;
                        break;
                    }
                } else if (n3 == 1) {
                    byteArray.append(13);
                }
                n3 = 0;
                if (n2 == 13) {
                    n3 = 1;
                    continue;
                }
                if (n2 != 32) {
                    bl = false;
                }
                byteArray.append(n2);
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (bl2) {
            n2 = (int)this.dataFile.getFilePointer() - n;
            ((RowInputText)this.rowIn).setSource(byteArray.toString(), n, n2);
            return this.rowIn;
        }
        return null;
    }

    int findNextUsedLinePos(int n) throws IOException {
        int n2 = n;
        int n3 = n;
        boolean bl = false;
        this.dataFile.seek(n);
        block6: while (true) {
            int n4 = this.dataFile.read();
            ++n3;
            switch (n4) {
                case -1: {
                    return n2 == n ? -1 : n2;
                }
                case 13: {
                    bl = true;
                    continue block6;
                }
                case 10: {
                    bl = false;
                    ((RowInputText)this.rowIn).skippedLine();
                    n2 = n3;
                    continue block6;
                }
                case 32: {
                    if (!bl) continue block6;
                    bl = false;
                    ((RowInputText)this.rowIn).skippedLine();
                    continue block6;
                }
            }
            break;
        }
        return n2;
    }

    protected void saveRows(CachedObject[] cachedObjectArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            CachedObject cachedObject = cachedObjectArray[i];
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
            cachedObjectArray[i] = null;
        }
    }

    public void saveRow(CachedObject cachedObject) throws IOException {
        this.uncommittedCache.remove(cachedObject.getPos());
        super.saveRow(cachedObject);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String string) throws HsqlException {
        if (this.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(string);
                this.header = string;
            }
            catch (IOException iOException) {
                throw new HsqlException(iOException, Trace.getMessage(98), 98);
            }
            return;
        }
        throw Trace.error(150);
    }

    private void writeHeader(String string) throws IOException {
        byte[] byArray = null;
        String string2 = string + NL;
        try {
            byArray = string2.getBytes(this.stringEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string2.getBytes();
        }
        this.dataFile.write(byArray, 0, byArray.length);
        this.fileFreePosition = string2.length();
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    protected void setFileModified() throws IOException {
        this.fileModified = true;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n) {
            this.buffer = new byte[n];
            this.buflen = 0;
        }

        public void append(int n) {
            if (this.buflen >= this.buffer.length) {
                byte[] byArray = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buflen);
                this.buffer = byArray;
            }
            this.buffer[this.buflen] = (byte)n;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int n) {
            this.buflen = n;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

