/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Imp;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.tiles.CustomTilemap;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.Tilemap;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class AmbitiousImpRoom
extends SpecialRoom {
    @Override
    public int maxWidth() {
        return 9;
    }

    @Override
    public int minWidth() {
        return 9;
    }

    @Override
    public int maxHeight() {
        return 9;
    }

    @Override
    public int minHeight() {
        return 9;
    }

    @Override
    public void paint(Level level) {
        Painter.fill(level, this, 12);
        Painter.fill(level, this, 1, 1);
        Point c = this.center();
        Painter.set(level, c.x - 2, c.y - 2, 33);
        Painter.set(level, c.x + 2, c.y - 2, 33);
        Painter.set(level, c.x - 2, c.y + 2, 33);
        Painter.set(level, c.x + 2, c.y + 2, 33);
        Painter.set(level, c.x - 3, c.y - 3, 12);
        Painter.set(level, c.x + 3, c.y - 3, 12);
        Painter.set(level, c.x - 3, c.y + 3, 12);
        Painter.set(level, c.x + 3, c.y + 3, 12);
        Room.Door entrance = this.entrance();
        Imp npc = new Imp();
        npc.pos = level.pointToCell(c);
        if (entrance.x == this.left || entrance.x == this.right) {
            npc.pos += Random.IntRange(-1, 1) * level.width();
            npc.pos = npc.pos + (entrance.x == this.left ? -2 : 2);
        } else if (entrance.y == this.top || entrance.y == this.bottom) {
            npc.pos += Random.IntRange(-1, 1);
            npc.pos = npc.pos + level.width() * (entrance.y == this.top ? -2 : 2);
        }
        level.mobs.add(npc);
        Painter.drawInside(level, this, entrance, 1, 1);
        entrance.set(Room.Door.Type.REGULAR);
        QuestEntrance vis = new QuestEntrance();
        vis.pos(c.x - 2, c.y - 2);
        level.customTiles.add(vis);
        EntranceBarrier vis2 = new EntranceBarrier();
        vis2.pos(c.x - 1, c.y - 1);
        level.customTiles.add(vis2);
        int entrancePos = level.pointToCell(c);
        level.transitions.add(new LevelTransition(level, entrancePos, LevelTransition.Type.BRANCH_EXIT, Dungeon.depth, Dungeon.branch + 1, LevelTransition.Type.BRANCH_ENTRANCE));
        Painter.set(level, entrancePos, 8);
    }

    @Override
    public boolean canPlaceCharacter(Point p, Level l) {
        return false;
    }

    @Override
    public boolean canPlaceItem(Point p, Level l) {
        return false;
    }

    @Override
    public boolean canPlaceTrap(Point p) {
        return false;
    }

    @Override
    public boolean canPlaceGrass(Point p) {
        return Point.distance(p, this.center()) >= 3.0f;
    }

    @Override
    public boolean canPlaceWater(Point p) {
        return Point.distance(p, this.center()) >= 3.0f;
    }

    public static class QuestEntrance
    extends CustomTilemap {
        final int TEX_WIDTH = 128;

        public QuestEntrance() {
            this.texture = "environment/custom_tiles/city_quest.png";
            this.tileH = 5;
            this.tileW = 5;
            this.TEX_WIDTH = 128;
        }

        @Override
        public Tilemap create() {
            Tilemap v = super.create();
            v.map(this.mapSimpleImage(0, 0, 128), 5);
            return v;
        }

        @Override
        public String name(int tileX, int tileY) {
            return Messages.get(this, "name", new Object[0]);
        }

        @Override
        public String desc(int tileX, int tileY) {
            return Messages.get(this, "desc", new Object[0]);
        }

        @Override
        public Image image(int tileX, int tileY) {
            if (tileX >= 1 && tileX < 4 && tileY >= 1 && tileY < 4) {
                return super.image(tileX, tileY);
            }
            return null;
        }
    }

    public static class EntranceBarrier
    extends CustomTilemap {
        final int TEX_WIDTH = 128;

        public EntranceBarrier() {
            this.texture = "environment/custom_tiles/city_quest.png";
            this.tileH = 3;
            this.tileW = 3;
            this.TEX_WIDTH = 128;
        }

        @Override
        public Tilemap create() {
            if (this.vis != null && this.vis.alive) {
                this.vis.killAndErase();
            }
            this.vis = new Tilemap(this.texture, new TextureFilm(this.texture, 16, 16)){

                @Override
                protected NoosaScript script() {
                    return NoosaScript.get();
                }

                @Override
                public void update() {
                    this.alpha(0.3f + 0.3f * (float)Math.sin(Game.timeTotal));
                    super.update();
                }
            };
            this.vis.x = this.tileX * 16;
            this.vis.y = this.tileY * 16;
            this.vis.map(this.mapSimpleImage(5, 1, 128), 3);
            return this.vis;
        }

        @Override
        public Image image(int tileX, int tileY) {
            return null;
        }
    }
}

