/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.response.AutoStateTransferResponse;
import org.infinispan.xsite.status.SiteState;

public class XSiteAutoTransferStatusCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 35;
    private String site;

    public XSiteAutoTransferStatusCommand() {
        super(null);
    }

    public XSiteAutoTransferStatusCommand(ByteString cacheName) {
        super(cacheName);
    }

    public XSiteAutoTransferStatusCommand(ByteString cacheName, String site) {
        super(cacheName);
        this.site = site;
    }

    @Override
    public byte getCommandId() {
        return 35;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeUTF(this.site);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.site = input.readUTF();
    }

    public CompletionStage<AutoStateTransferResponse> invokeAsync(ComponentRegistry registry) throws Throwable {
        boolean offline = registry.getTakeOfflineManager().running().getSiteState(this.site) == SiteState.OFFLINE;
        XSiteStateTransferMode mode = registry.getXSiteStateTransferManager().running().stateTransferMode(this.site);
        return CompletableFuture.completedFuture(new AutoStateTransferResponse(offline, mode));
    }

    @Override
    public String toString() {
        return "XSiteAutoTransferStatusCommand{cacheName=" + String.valueOf(this.cacheName) + ", site='" + this.site + "'}";
    }
}

