/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.resource.JarFileResource;
import io.smallrye.common.resource.PathResource;
import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceLoader;
import io.smallrye.common.resource.ResourceUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class JarFileResourceLoader
implements ResourceLoader {
    private final URL base;
    private final JarFile jarFile;
    private Path tempFile;

    public JarFileResourceLoader(Path jarPath) throws IOException {
        this.base = jarPath.toUri().toURL();
        this.jarFile = new JarFile(jarPath.toFile(), true, 1, JarFile.runtimeVersion());
    }

    public JarFileResourceLoader(Resource resource) throws IOException {
        this.base = resource.url();
        JarFile jf = null;
        if (resource instanceof PathResource) {
            PathResource pr = (PathResource)resource;
            try {
                jf = new JarFile(pr.path().toFile(), true, 1, JarFile.runtimeVersion());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (jf == null) {
            this.tempFile = Files.createTempFile("srcr-tmp-", ".jar", new FileAttribute[0]);
            try {
                resource.copyTo(this.tempFile);
                jf = new JarFile(this.tempFile.toFile(), true, 1, JarFile.runtimeVersion());
            }
            catch (Throwable t) {
                try {
                    Files.delete(this.tempFile);
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }
        this.jarFile = jf;
    }

    @Override
    public Resource findResource(String path) {
        String canonPath = ResourceUtils.canonicalizeRelativePath(path);
        if (canonPath.isEmpty()) {
            JarEntry entry = new JarEntry("/");
            entry.setSize(0L);
            entry.setCompressedSize(0L);
            return new JarFileResource(this.base, this.jarFile, entry);
        }
        JarEntry jarEntry = this.jarFile.getJarEntry(canonPath);
        if (jarEntry != null) {
            return new JarFileResource(this.base, this.jarFile, jarEntry);
        }
        jarEntry = this.jarFile.getJarEntry(canonPath + "/");
        if (jarEntry != null) {
            return new JarFileResource(this.base, this.jarFile, jarEntry);
        }
        String dirName = canonPath + "/";
        boolean found = this.jarFile.versionedStream().map(ZipEntry::getName).map(ResourceUtils::canonicalizeRelativePath).anyMatch(n -> n.startsWith(dirName));
        if (found) {
            JarEntry entry = new JarEntry(dirName);
            entry.setSize(0L);
            entry.setCompressedSize(0L);
            return new JarFileResource(this.base, this.jarFile, entry);
        }
        return null;
    }

    @Override
    public URL baseUrl() {
        return this.base;
    }

    @Override
    public Manifest manifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.tempFile != null) {
            try {
                Files.delete(this.tempFile);
            }
            catch (IOException iOException) {
            }
            finally {
                this.tempFile = null;
            }
        }
    }
}

