/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FunctionTable
implements StructConverter {
    public static final String NAME = "MINIDUMP_FUNCTION_TABLE";
    private long minimumAddress;
    private long maximumAddress;
    private long baseAddress;
    private int entryCount;
    private int sizeOfAlignPad;
    private DumpFileReader reader;
    private long index;

    FunctionTable(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setMinimumAddress(this.reader.readNextLong());
        this.setMaximumAddress(this.reader.readNextLong());
        this.setBaseAddress(this.reader.readNextLong());
        this.setEntryCount(this.reader.readNextInt());
        this.setSizeOfAlignPad(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "MinimumAddress", null);
        struct.add(QWORD, 8, "MaximumAddress", null);
        struct.add(QWORD, 8, "BaseAddress", null);
        struct.add(DWORD, 4, "EntryCount", null);
        struct.add(DWORD, 4, "SizeOfAlignPad", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getMinimumAddress() {
        return this.minimumAddress;
    }

    public void setMinimumAddress(long minimumAddress) {
        this.minimumAddress = minimumAddress;
    }

    public long getMaximumAddress() {
        return this.maximumAddress;
    }

    public void setMaximumAddress(long maximumAddress) {
        this.maximumAddress = maximumAddress;
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(long baseAddress) {
        this.baseAddress = baseAddress;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(int entryCount) {
        this.entryCount = entryCount;
    }

    public int getSizeOfAlignPad() {
        return this.sizeOfAlignPad;
    }

    public void setSizeOfAlignPad(int sizeOfAlignPad) {
        this.sizeOfAlignPad = sizeOfAlignPad;
    }
}

