/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.Varnode;

public class ParamMeasure {
    private Varnode vn = null;
    private DataType dt = null;
    private Integer rank = null;

    public boolean isEmpty() {
        return this.vn == null;
    }

    public void decode(Decoder decoder, PcodeFactory factory) throws DecoderException {
        this.vn = Varnode.decode(decoder, factory);
        this.dt = factory.getDataTypeManager().decodeDataType(decoder);
        int rankel = decoder.openElement(ElementId.ELEM_RANK);
        this.rank = (int)decoder.readSignedInteger(AttributeId.ATTRIB_VAL);
        decoder.closeElement(rankel);
    }

    public Varnode getVarnode() {
        return this.vn;
    }

    public DataType getDataType() {
        return this.dt;
    }

    public Integer getRank() {
        return this.rank;
    }
}

