/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.DefaultAssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.DefaultAssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.DefaultAssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAssemblyResolutionFactory<RP extends AssemblyResolvedPatterns, BF extends AssemblyResolvedBackfill> {
    protected static final RecursiveDescentSolver SOLVER = RecursiveDescentSolver.getSolver();
    protected static final String INS = "ins:";
    protected static final String CTX = "ctx:";
    protected static final String SEP = ",";

    public abstract AbstractAssemblyResolvedPatternsBuilder<RP> newPatternsBuilder();

    public abstract AbstractAssemblyResolvedBackfillBuilder<BF> newBackfillBuilder();

    public AssemblyResolvedErrorBuilder newErrorBuilder() {
        return new AssemblyResolvedErrorBuilder();
    }

    protected AssemblyResolutionResults singleton(AssemblyResolution one) {
        return this.results(Set.of(one));
    }

    public AssemblyResolutionResults newAssemblyResolutionResults() {
        return new AssemblyResolutionResults();
    }

    protected AssemblyResolutionResults results(Set<AssemblyResolution> col) {
        return new AssemblyResolutionResults(col);
    }

    protected AssemblyResolution solveOrBackfill(PatternExpression exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, String description) {
        try {
            return SOLVER.solve(this, exp, goal, vals, cur, description);
        }
        catch (NeedsBackfillException bf) {
            int fieldLength = SOLVER.getInstructionLength(exp);
            return this.backfill(exp, goal, fieldLength, description);
        }
    }

    protected AssemblyResolution solveOrBackfill(PatternExpression exp, long goal, int bits, Map<String, Long> vals, AssemblyResolvedPatterns cur, String description) {
        long msk = bits == 0 || bits >= 64 ? -1L : -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
        return this.solveOrBackfill(exp, MaskedLong.fromMaskAndValue(msk, goal), vals, cur, description);
    }

    protected AssemblyResolution solveOrBackfill(PatternExpression exp, long goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, String description) {
        return this.solveOrBackfill(exp, MaskedLong.fromLong(goal), vals, cur, description);
    }

    public AssemblyResolvedErrorBuilder errorBuilder(String error, AssemblyResolution res) {
        AssemblyResolvedErrorBuilder builder = this.newErrorBuilder();
        builder.error = error;
        builder.description = res.getDescription();
        builder.children = res.getChildren();
        builder.right = res.getRight();
        return builder;
    }

    public AssemblyResolution error(String error, AssemblyResolution res) {
        return this.errorBuilder(error, res).build();
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> nopBuilder(String description) {
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.ins = AssemblyPatternBlock.nop();
        builder.ctx = AssemblyPatternBlock.nop();
        builder.description = description;
        return builder;
    }

    public RP nop(String description) {
        return (RP)((AssemblyResolvedPatterns)this.nopBuilder(description).build());
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> nopBuilder(String description, List<AssemblyResolution> children, AssemblyResolution right) {
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.ins = AssemblyPatternBlock.nop();
        builder.ctx = AssemblyPatternBlock.nop();
        builder.description = description;
        builder.children = children;
        builder.right = right;
        return builder;
    }

    public RP nop(String description, List<AssemblyResolution> children, AssemblyResolution right) {
        return (RP)((AssemblyResolvedPatterns)this.nopBuilder(description, children, right).build());
    }

    public AbstractAssemblyResolvedBackfillBuilder<BF> backfillBuilder(PatternExpression exp, MaskedLong goal, int inslen, String description) {
        AbstractAssemblyResolvedBackfillBuilder<BF> builder = this.newBackfillBuilder();
        builder.exp = exp;
        builder.goal = goal;
        builder.inslen = inslen;
        builder.description = description;
        return builder;
    }

    public AssemblyResolution backfill(PatternExpression exp, MaskedLong goal, int inslen, String description) {
        return this.backfillBuilder(exp, goal, inslen, description).build();
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> resolvedBuilder(AssemblyPatternBlock ins, AssemblyPatternBlock ctx, String description, Constructor cons, List<AssemblyResolution> children, AssemblyResolution right) {
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.ins = ins;
        builder.ctx = ctx;
        builder.description = description;
        builder.cons = cons;
        builder.children = children;
        builder.right = right;
        return builder;
    }

    public RP resolved(AssemblyPatternBlock ins, AssemblyPatternBlock ctx, String description, Constructor cons, List<AssemblyResolution> children, AssemblyResolution right) {
        return (RP)((AssemblyResolvedPatterns)this.resolvedBuilder(ins, ctx, description, cons, children, right).build());
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> instrOnlyBuilder(AssemblyPatternBlock ins, String description) {
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.ins = ins;
        builder.ctx = AssemblyPatternBlock.nop();
        builder.description = description;
        return builder;
    }

    public RP instrOnly(AssemblyPatternBlock ins, String description) {
        return (RP)((AssemblyResolvedPatterns)this.instrOnlyBuilder(ins, description).build());
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> contextOnlyBuilder(AssemblyPatternBlock ctx, String description) {
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.ins = AssemblyPatternBlock.nop();
        builder.ctx = ctx;
        builder.description = description;
        return builder;
    }

    public RP contextOnly(AssemblyPatternBlock ctx, String description) {
        return (RP)((AssemblyResolvedPatterns)this.contextOnlyBuilder(ctx, description).build());
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> fromPatternBuilder(DisjointPattern pat, int minLen, String description, Constructor cons) {
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.ins = AssemblyPatternBlock.fromPattern(pat, minLen, false);
        builder.ctx = AssemblyPatternBlock.fromPattern(pat, 0, true);
        builder.description = description;
        builder.cons = cons;
        return builder;
    }

    public RP fromPattern(DisjointPattern pat, int minLen, String description, Constructor cons) {
        return (RP)((AssemblyResolvedPatterns)this.fromPatternBuilder(pat, minLen, description, cons).build());
    }

    protected AbstractAssemblyResolvedPatternsBuilder<RP> fromStringBuilder(String str, String description, List<AssemblyResolution> children) {
        int end;
        AbstractAssemblyResolvedPatternsBuilder<RP> builder = this.newPatternsBuilder();
        builder.description = description;
        builder.children = children;
        if (str.startsWith(INS)) {
            end = str.indexOf(SEP);
            if (end == -1) {
                end = str.length();
            }
            builder.ins = AssemblyPatternBlock.fromString(str.substring(INS.length(), end));
            if ((str = str.substring(end)).startsWith(SEP)) {
                str = str.substring(1);
            }
        }
        if (str.startsWith(CTX)) {
            end = str.length();
            builder.ctx = AssemblyPatternBlock.fromString(str.substring(CTX.length(), end));
            str = str.substring(end);
        }
        if (str.length() != 0) {
            throw new IllegalArgumentException(str);
        }
        return builder;
    }

    public AssemblyResolvedPatterns fromString(String str, String description, List<AssemblyResolution> children) {
        return (AssemblyResolvedPatterns)this.fromStringBuilder(str, description, children).build();
    }

    public class AssemblyResolvedErrorBuilder
    extends AbstractAssemblyResolutionBuilder<AssemblyResolvedErrorBuilder, AssemblyResolvedError> {
        protected String error;

        public AssemblyResolvedErrorBuilder error(String error) {
            this.error = error;
            return (AssemblyResolvedErrorBuilder)this.self();
        }

        @Override
        public AssemblyResolvedError build() {
            return new DefaultAssemblyResolvedError(AbstractAssemblyResolutionFactory.this, this.description, this.children, this.right, this.error);
        }
    }

    public static abstract class AbstractAssemblyResolvedPatternsBuilder<RP extends AssemblyResolvedPatterns>
    extends AbstractAssemblyResolutionBuilder<AbstractAssemblyResolvedPatternsBuilder<RP>, RP> {
        protected Constructor cons;
        protected AssemblyPatternBlock ins;
        protected AssemblyPatternBlock ctx;
        protected Set<AssemblyResolvedBackfill> backfills;
        protected Set<AssemblyResolvedPatterns> forbids;

        public void copyFromDefault(DefaultAssemblyResolvedPatterns rp) {
            super.copyFromDefault(rp);
            this.cons = rp.cons;
            this.ins = rp.ins;
            this.ctx = rp.ctx;
            this.backfills = rp.backfills;
            this.forbids = rp.forbids;
        }
    }

    public static abstract class AbstractAssemblyResolvedBackfillBuilder<BF extends AssemblyResolvedBackfill>
    extends AbstractAssemblyResolutionBuilder<AbstractAssemblyResolvedBackfillBuilder<BF>, BF> {
        protected PatternExpression exp;
        protected MaskedLong goal;
        protected int inslen;
        protected int offset;
    }

    public class DefaultAssemblyResolvedBackfillBuilder
    extends AbstractAssemblyResolvedBackfillBuilder<AssemblyResolvedBackfill> {
        @Override
        protected AssemblyResolvedBackfill build() {
            return new DefaultAssemblyResolvedBackfill(AbstractAssemblyResolutionFactory.this, this.description, this.exp, this.goal, this.inslen, this.offset);
        }
    }

    public class DefaultAssemblyResolvedPatternBuilder
    extends AbstractAssemblyResolvedPatternsBuilder<AssemblyResolvedPatterns> {
        @Override
        protected AssemblyResolvedPatterns build() {
            return new DefaultAssemblyResolvedPatterns(AbstractAssemblyResolutionFactory.this, this.description, this.cons, this.children, this.right, this.ins, this.ctx, this.backfills, this.forbids);
        }
    }

    public static abstract class AbstractAssemblyResolutionBuilder<B extends AbstractAssemblyResolutionBuilder<B, T>, T extends AssemblyResolution> {
        protected String description;
        protected List<AssemblyResolution> children;
        protected AssemblyResolution right;

        public void copyFromDefault(AbstractAssemblyResolution ar) {
            this.description = ar.description;
            this.children = ar.children;
            this.right = ar.right;
        }

        protected B self() {
            return (B)this;
        }

        public B description(String description) {
            this.description = description;
            return this.self();
        }

        public B children(List<AssemblyResolution> children) {
            this.children = children;
            return this.self();
        }

        public B right(AssemblyResolution right) {
            this.right = right;
            return this.self();
        }

        protected abstract T build();
    }
}

