/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.CellEditor;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;

public class GTreeStartEditingTask
extends GTreeTask {
    private final GTreeNode modelParent;
    private final GTreeNode editNode;

    public GTreeStartEditingTask(GTree gTree, JTree jTree, GTreeNode editNode) {
        super(gTree);
        this.modelParent = this.tree.getModelNode(editNode.getParent());
        this.editNode = editNode;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            this.edit();
        });
    }

    public long getPriority() {
        return Long.MAX_VALUE;
    }

    private void edit() {
        TreePath path = this.editNode.getTreePath();
        final CellEditor cellEditor = this.tree.getCellEditor();
        cellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                cellEditor.removeCellEditorListener(this);
                GTreeStartEditingTask.this.tree.setSelectedNode(GTreeStartEditingTask.this.editNode);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                String newName = Objects.toString(cellEditor.getCellEditorValue());
                cellEditor.removeCellEditorListener(this);
                Class<?> nodeClass = GTreeStartEditingTask.this.editNode.getClass();
                Predicate<GTreeNode> nodeMatches = n -> nodeClass == n.getClass() && n.getName().equals(newName);
                GTreeStartEditingTask.this.tree.whenNodeIsReady(GTreeStartEditingTask.this.modelParent, nodeMatches, newNode -> GTreeStartEditingTask.this.tree.setSelectedNode((GTreeNode)newNode));
            }
        });
        this.tree.setNodeEditable(this.editNode);
        this.jTree.startEditingAtPath(path);
    }
}

