/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.macro.entry;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFFormContext;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroHeader;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroOpcode;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroDefine;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroEndFile;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroImport;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroStartFile;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroUndef;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DWARFMacroInfoEntry {
    protected DWARFMacroOpcode opcode;
    protected int rawOpcode;
    protected DWARFAttributeValue[] operandValues;
    protected DWARFMacroHeader macroHeader;

    public static DWARFMacroInfoEntry read(BinaryReader reader, DWARFMacroHeader macroHeader) throws IOException {
        Map<Integer, List<DWARFForm>> opcodeMap = macroHeader.getOpcodeMap();
        long startOffset = reader.getPointerIndex();
        int rawOpcode = reader.readNextUnsignedByte();
        DWARFMacroOpcode opcode = DWARFMacroOpcode.of(rawOpcode);
        List<DWARFForm> operandForms = opcodeMap.get(rawOpcode);
        if (operandForms == null) {
            throw new IOException("Unknown DW_MACRO opcode %x at position %d [0x%x]".formatted(rawOpcode, startOffset, startOffset));
        }
        DWARFAttributeValue[] operandValues = new DWARFAttributeValue[operandForms.size()];
        for (int i = 0; i < operandForms.size(); ++i) {
            DWARFForm form = operandForms.get(i);
            DWARFMacroOpcode.Def opcodeDef = new DWARFMacroOpcode.Def(opcode, rawOpcode, form);
            DWARFFormContext readContext = new DWARFFormContext(reader, macroHeader.getCompilationUnit(), opcodeDef, macroHeader.getIntSize());
            operandValues[i] = form.readValue(readContext);
        }
        DWARFMacroInfoEntry genericEntry = new DWARFMacroInfoEntry(opcode, rawOpcode, operandValues, macroHeader);
        return DWARFMacroInfoEntry.toSpecializedForm(genericEntry);
    }

    public static DWARFMacroInfoEntry toSpecializedForm(DWARFMacroInfoEntry genericEntry) {
        return switch (genericEntry.getOpcode()) {
            case DWARFMacroOpcode.MACRO_UNIT_TERMINATOR -> null;
            case DWARFMacroOpcode.DW_MACRO_define, DWARFMacroOpcode.DW_MACRO_define_strp, DWARFMacroOpcode.DW_MACRO_define_sup, DWARFMacroOpcode.DW_MACRO_define_strx -> new DWARFMacroDefine(genericEntry);
            case DWARFMacroOpcode.DW_MACRO_undef, DWARFMacroOpcode.DW_MACRO_undef_strp, DWARFMacroOpcode.DW_MACRO_undef_sup, DWARFMacroOpcode.DW_MACRO_undef_strx -> new DWARFMacroUndef(genericEntry);
            case DWARFMacroOpcode.DW_MACRO_start_file -> new DWARFMacroStartFile(genericEntry);
            case DWARFMacroOpcode.DW_MACRO_end_file -> new DWARFMacroEndFile(genericEntry);
            case DWARFMacroOpcode.DW_MACRO_import, DWARFMacroOpcode.DW_MACRO_import_sup -> new DWARFMacroImport(genericEntry);
            default -> genericEntry;
        };
    }

    protected DWARFMacroInfoEntry(DWARFMacroOpcode opcode, DWARFMacroHeader macroHeader) {
        this.opcode = opcode;
        this.rawOpcode = opcode.getRawOpcode();
        this.macroHeader = macroHeader;
        this.operandValues = new DWARFAttributeValue[opcode.getOperandForms().length];
    }

    public DWARFMacroInfoEntry(DWARFMacroOpcode opcode, int rawOpcode, DWARFAttributeValue[] operandValues, DWARFMacroHeader macroHeader) {
        this.opcode = opcode;
        this.rawOpcode = rawOpcode;
        this.operandValues = operandValues;
        this.macroHeader = macroHeader;
    }

    protected DWARFMacroInfoEntry(DWARFMacroInfoEntry other) {
        this.opcode = other.opcode;
        this.rawOpcode = other.rawOpcode;
        this.operandValues = other.operandValues;
        this.macroHeader = other.macroHeader;
    }

    public DWARFMacroOpcode getOpcode() {
        return this.opcode;
    }

    public String getName() {
        return this.opcode != null ? this.opcode.getDescription() : "DW_MACRO_unknown[%x]".formatted(this.rawOpcode);
    }

    public <T extends DWARFAttributeValue> T getOperand(int index, Class<T> valueClass) throws IOException {
        DWARFAttributeValue val = this.operandValues[index];
        if (valueClass.isInstance(val)) {
            return (T)((DWARFAttributeValue)valueClass.cast(val));
        }
        throw new IOException("Incompatible operand type %s for %s".formatted(valueClass.getSimpleName(), this.toString()));
    }

    protected DWARFAttributeDef<DWARFMacroOpcode> operandDef(int operandIndex) {
        return new DWARFMacroOpcode.Def(this.opcode, this.rawOpcode, this.opcode.getOperandForms()[operandIndex]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        if (this.operandValues.length > 0) {
            sb.append(": ");
            for (int i = 0; i < this.operandValues.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.operandValues[i].getValueString(this.macroHeader.getCompilationUnit()));
            }
        }
        return sb.toString();
    }
}

