/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.DockingUtils;
import docking.actions.KeyBindingUtils;
import docking.dnd.DragGestureAdapter;
import docking.dnd.Draggable;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.table.AutoscrollAdapter;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.programtree.DnDTreeCellRenderer;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeTransferable;
import ghidra.app.plugin.core.programtree.TreeDragSrcAdapter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class DragNDropTree
extends JTree
implements Draggable,
Droppable,
Autoscroll {
    private static final Color BG_COLOR_DRAG_NO_SELECTION = new GColor("color.bg.tree.drag");
    private AutoscrollAdapter autoscroller;
    protected DefaultTreeModel model;
    protected DragSource dragSource;
    protected DragGestureAdapter dragGestureAdapter;
    protected TreeDragSrcAdapter dragSourceAdapter;
    protected int dragAction = 3;
    protected DropTarget dropTarget;
    protected DropTgtAdapter dropTargetAdapter;
    protected ProgramNode root;
    protected Color plafSelectionColor;
    protected DnDTreeCellRenderer dndCellRenderer;
    protected boolean drawFeedback;
    protected ProgramNode[] draggedNodes;
    protected ProgramNode destinationNode;
    protected DataFlavor[] acceptableFlavors;
    protected ProgramTreeTransferable transferable;
    protected Color nonSelectionDragColor;
    protected int relativeMousePos;

    public DragNDropTree(DefaultTreeModel model) {
        super(model);
        this.setBackground((Color)new GColor("color.bg.tree"));
        this.model = model;
        this.root = (ProgramNode)model.getRoot();
        this.setShowsRootHandles(true);
        ProgramTreeCellEditor treeCellEditor = new ProgramTreeCellEditor(this);
        this.setCellEditor(treeCellEditor);
        this.dndCellRenderer = new DnDTreeCellRenderer();
        this.setCellRenderer(this.dndCellRenderer);
        this.plafSelectionColor = this.dndCellRenderer.getBackgroundSelectionColor();
        this.nonSelectionDragColor = BG_COLOR_DRAG_NO_SELECTION;
        this.initDragNDrop();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.autoscroller = new AutoscrollAdapter((JComponent)this, this.getRowHeight());
        this.disableJTreeTransferActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStartDragOk(DragGestureEvent e) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            Point p = e.getDragOrigin();
            ProgramNode node = this.getTreeNode(p);
            if (node == null || node.equals(this.root)) {
                return false;
            }
            if (this.isEditing()) {
                this.stopEditing();
            }
            return true;
        }
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public int getDragAction() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getTransferable(Point p) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            TreePath[] selectionPaths = this.getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length == 0) {
                return null;
            }
            ProgramNode[] nodes = new ProgramNode[selectionPaths.length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = (ProgramNode)selectionPaths[i].getLastPathComponent();
            }
            this.transferable = new ProgramTreeTransferable(nodes);
            this.draggedNodes = nodes;
            return this.transferable;
        }
    }

    public void dragFinished(boolean wasCancelled) {
        this.draggedNodes = null;
        this.dndCellRenderer.setBackgroundSelectionColor(this.plafSelectionColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDropOk(DropTargetDragEvent e) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            Point p = e.getLocation();
            ProgramNode targetNode = this.getTreeNode(p);
            if (this.isEditing()) {
                this.stopEditing();
            }
            if (targetNode == null) {
                return false;
            }
            if (this.dragSelectionContainsTarget(targetNode)) {
                return false;
            }
            if (this.draggedNodes == null) {
                return this.isDropSiteOk(targetNode, e);
            }
            if (this.draggedNodes.length > 0 && this.draggedNodes[0].equals(this.root)) {
                return false;
            }
            return !this.dragSelectionContainsDescendant(targetNode);
        }
    }

    private boolean dragSelectionContainsTarget(ProgramNode targetNode) {
        if (this.draggedNodes == null) {
            return false;
        }
        for (ProgramNode draggedNode : this.draggedNodes) {
            if (!targetNode.equals(draggedNode)) continue;
            return true;
        }
        return false;
    }

    private boolean dragSelectionContainsDescendant(ProgramNode targetNode) {
        if (this.draggedNodes == null) {
            return false;
        }
        for (ProgramNode draggedNode : this.draggedNodes) {
            if (!targetNode.isNodeAncestor(draggedNode)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            Point p;
            this.drawFeedback = true;
            this.cancelEditing();
            if (ok) {
                p = e.getLocation();
                TreePath path = this.getPathForLocation(p.x, p.y);
                if (path == null) {
                    return;
                }
                this.destinationNode = (ProgramNode)path.getLastPathComponent();
                this.relativeMousePos = this.comparePointerLocation(p, this.destinationNode);
                int action = e.getDropAction();
                this.dragSourceAdapter.setFeedbackCursor(null);
                Cursor c = this.dragSourceAdapter.getDropOkCursor(action);
                if (this.relativeMousePos != 0) {
                    this.drawFeedback = false;
                    c = this.dragSourceAdapter.getCursor(action, this.relativeMousePos);
                } else {
                    this.dndCellRenderer.setSelectionForDrag(this.plafSelectionColor);
                    this.dndCellRenderer.setNonSelectionForDrag(this.nonSelectionDragColor);
                }
                this.dragSourceAdapter.setFeedbackCursor(c);
            } else {
                this.destinationNode = null;
                this.dndCellRenderer.setSelectionForDrag((Color)GThemeDefaults.Colors.ERROR);
                this.dndCellRenderer.setNonSelectionForDrag((Color)GThemeDefaults.Colors.ERROR);
            }
            p = e.getLocation();
            this.dndCellRenderer.setRowForFeedback(this.getRowForLocation(p.x, p.y));
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoDragUnderFeedback() {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            this.drawFeedback = false;
        }
        this.repaint();
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.autoscroller.getAutoscrollInsets();
    }

    @Override
    public void autoscroll(Point p) {
        this.autoscroller.autoscroll(p);
    }

    protected abstract DataFlavor[] getAcceptableDataFlavors();

    protected abstract boolean isDropSiteOk(ProgramNode var1, DropTargetDragEvent var2);

    protected abstract String getToolTipText(ProgramNode var1);

    protected ProgramNode getTreeNode(Point p) {
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (path != null) {
            return (ProgramNode)path.getLastPathComponent();
        }
        return null;
    }

    boolean getDrawFeedbackState() {
        return this.drawFeedback;
    }

    protected int comparePointerLocation(Point p, ProgramNode node) {
        int localRowHeight = this.getRowHeight();
        int row = this.getRowForPath(node.getTreePath());
        Rectangle rect = this.getRowBounds(row);
        if (p.y == rect.y) {
            return 1;
        }
        if (p.y - rect.y <= localRowHeight) {
            int delta = localRowHeight - (p.y - rect.y);
            int sliceSize = localRowHeight / 4;
            if (delta < sliceSize) {
                return 1;
            }
            if (delta > sliceSize * 3) {
                return -1;
            }
        }
        return 0;
    }

    private void initDragNDrop() {
        this.acceptableFlavors = this.getAcceptableDataFlavors();
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
        this.dropTarget = new DropTarget(this, 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new TreeDragSrcAdapter(this);
        this.dragSource.createDefaultDragGestureRecognizer(this, this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    private void disableJTreeTransferActions() {
        KeyBindingUtils.clearKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(86, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(88, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
    }

    private class ProgramTreeCellEditor
    extends DefaultTreeCellEditor {
        public ProgramTreeCellEditor(DragNDropTree dragNDropTree) {
            super(dragNDropTree, null);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            ((JTextField)this.editingComponent).selectAll();
            return super.shouldSelectCell(anEvent);
        }
    }
}

