/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.hash;

import ghidra.feature.fid.hash.FunctionExtentGenerator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.List;

public class FunctionBodyFunctionExtentGenerator
implements FunctionExtentGenerator {
    @Override
    public List<CodeUnit> calculateExtent(Function func) {
        if (func == null) {
            return List.of();
        }
        AddressSetView body = func.getBody();
        if (body.isEmpty()) {
            return List.of();
        }
        ArrayList<CodeUnit> units = new ArrayList<CodeUnit>();
        Program program = func.getProgram();
        Listing listing = program.getListing();
        InstructionIterator codeUnitIterator = listing.getInstructions(body, true);
        for (Instruction codeUnit : codeUnitIterator) {
            units.add((CodeUnit)codeUnit);
        }
        return units;
    }
}

