/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.awt.event.InputEvent;
import javax.swing.Icon;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.commandsearch.AcceleratorDescriptionCreator;
import org.freeplane.features.commandsearch.ItemChecker;
import org.freeplane.features.commandsearch.SearchItem;

public class IconItem
extends SearchItem {
    private static final String ICONS_PATH = TextUtils.getText("icons") + "->";
    private final Icon icon;
    private final AFreeplaneAction action;
    private final String comparedText;
    private final String iconDescription;
    private final String searchedText;

    public IconItem(Icon icon, AFreeplaneAction action, String iconName, String path) {
        this.icon = icon;
        this.action = action;
        this.iconDescription = iconName + ", " + path;
        this.searchedText = IconItem.normalizeText(this.iconDescription);
        this.comparedText = path + "->" + iconName;
    }

    @Override
    public Icon getTypeIcon() {
        return this.icon;
    }

    @Override
    public String getDisplayedText() {
        return this.getTextWithAccelerator(this.iconDescription);
    }

    @Override
    public String getCopiedText() {
        return this.getTextWithAccelerator(ICONS_PATH + this.comparedText);
    }

    private String getTextWithAccelerator(String text) {
        String accelerator = AcceleratorDescriptionCreator.INSTANCE.createAcceleratorDescription(this.action);
        return text + (accelerator != null ? " (" + accelerator + ")" : "");
    }

    private String getSearchedText() {
        String accelerator = AcceleratorDescriptionCreator.INSTANCE.createAcceleratorDescription(this.action);
        return this.searchedText + (accelerator != null ? " (" + IconItem.normalizeText(accelerator) + ")" : "");
    }

    @Override
    public String getTooltip() {
        return null;
    }

    @Override
    void execute(InputEvent event) {
        this.action.actionPerformed(null);
    }

    @Override
    void assignNewAccelerator() {
        this.assignNewAccelerator(this.action);
    }

    @Override
    boolean shouldUpdateResultList() {
        return true;
    }

    @Override
    int getItemTypeRank() {
        return 3;
    }

    @Override
    public String getComparedText() {
        return this.comparedText;
    }

    @Override
    protected boolean checkAndMatch(String searchTerm, ItemChecker textChecker) {
        return textChecker.contains(this.getSearchedText(), searchTerm);
    }

    public String toString() {
        return "IconItem [" + this.getDisplayedText() + "]";
    }
}

