/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.parosproxy.paros.network.HtmlParameter;

public class HtmlParameterStats
implements Comparable<HtmlParameterStats> {
    private long id = -1L;
    private String site;
    private String name;
    private HtmlParameter.Type type;
    private int timesUsed = 0;
    private Set<String> flags = Collections.synchronizedSet(new HashSet());
    private Set<String> values = Collections.synchronizedSet(new HashSet());

    public HtmlParameterStats(String site, String name, HtmlParameter.Type type, String value, Set<String> flags) {
        this.site = site;
        this.name = name;
        this.type = type;
        this.addValue(value);
        this.flags = flags;
        this.incTimesUsed();
    }

    public HtmlParameterStats(long id, String site, String name, String type, int timesUsed, Set<String> values, Set<String> flags) {
        this.id = id;
        this.site = site;
        this.name = name;
        this.type = HtmlParameter.Type.valueOf(type);
        this.timesUsed = timesUsed;
        this.values = values;
        this.flags = flags;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getSite() {
        return this.site;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HtmlParameter.Type getType() {
        return this.type;
    }

    public void setType(HtmlParameter.Type type) {
        this.type = type;
    }

    public int getTimesUsed() {
        return this.timesUsed;
    }

    public void incTimesUsed() {
        ++this.timesUsed;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        if (value == null) {
            value = "";
        }
        this.values.add(value);
    }

    public String getValuesSummary() {
        StringBuilder sb = new StringBuilder();
        for (String value : this.values) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value);
            if (sb.length() <= 250) continue;
            break;
        }
        return sb.toString();
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public void addFlag(String flag) {
        this.flags.add(flag);
    }

    public String getAllFlags() {
        StringBuilder sb = new StringBuilder();
        for (String flag : this.flags) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(flag);
            if (sb.length() <= 250) continue;
            break;
        }
        return sb.toString();
    }

    @Override
    public int compareTo(HtmlParameterStats o) {
        if (o == null) {
            return 1;
        }
        int result = this.type.ordinal() - o.getType().ordinal();
        if (result == 0) {
            result = this.name.compareTo(o.getName());
        }
        return result;
    }

    public void removeFlag(String flag) {
        this.flags.remove(flag);
    }
}

