/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.SendCustomVerificationEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendCustomVerificationEmailRequestMarshaller
implements Marshaller<Request<SendCustomVerificationEmailRequest>, SendCustomVerificationEmailRequest> {
    public Request<SendCustomVerificationEmailRequest> marshall(SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) {
        if (sendCustomVerificationEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendCustomVerificationEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendCustomVerificationEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendCustomVerificationEmailRequest.getEmailAddress() != null) {
            request.addParameter("EmailAddress", StringUtils.fromString((String)sendCustomVerificationEmailRequest.getEmailAddress()));
        }
        if (sendCustomVerificationEmailRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)sendCustomVerificationEmailRequest.getTemplateName()));
        }
        if (sendCustomVerificationEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)sendCustomVerificationEmailRequest.getConfigurationSetName()));
        }
        return request;
    }
}

