/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.WorkflowStepProvider;

public class AddRequiredActionStepProvider
implements WorkflowStepProvider {
    public static String REQUIRED_ACTION_KEY = "action";
    private final KeycloakSession session;
    private final ComponentModel stepModel;
    private final Logger log = Logger.getLogger(AddRequiredActionStepProvider.class);

    public AddRequiredActionStepProvider(KeycloakSession session, ComponentModel model) {
        this.session = session;
        this.stepModel = model;
    }

    public void run(List<String> userIds) {
        RealmModel realm = this.session.getContext().getRealm();
        for (String id : userIds) {
            UserModel user = this.session.users().getUserById(realm, id);
            if (user == null) continue;
            try {
                UserModel.RequiredAction action = UserModel.RequiredAction.valueOf((String)((String)this.stepModel.getConfig().getFirst((Object)REQUIRED_ACTION_KEY)));
                this.log.debugv("Adding required action {0} to user {1})", (Object)action, (Object)user.getId());
                user.addRequiredAction(action);
            }
            catch (IllegalArgumentException e) {
                this.log.warnv("Invalid required action {0} configured in AddRequiredActionProvider", this.stepModel.getConfig().getFirst((Object)REQUIRED_ACTION_KEY));
            }
        }
    }

    public void close() {
    }
}

