/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.field.FieldElement;
import java.util.ArrayList;
import java.util.List;

public class FieldUtils {
    public static final String WORD_WRAP_OPTION_NAME = "Enable Word Wrapping";
    public static final String WORD_WRAP_OPTION_DESCRIPTION = "Enables word wrapping.  When on, each line of text is wrapped as needed to fit within the current width.  When off, comments are displayed as entered by the user.  Lines that are too long for the field are truncated.";

    private FieldUtils() {
    }

    public static List<FieldElement> wrap(List<FieldElement> fieldElements, int width) {
        ArrayList<FieldElement> wrappedElements = new ArrayList<FieldElement>();
        for (FieldElement fieldElement : fieldElements) {
            wrappedElements.addAll(FieldUtils.wrap(fieldElement, width));
        }
        return wrappedElements;
    }

    public static List<FieldElement> wrap(FieldElement fieldElement, int width) {
        ArrayList<FieldElement> lines = new ArrayList<FieldElement>();
        if (fieldElement.getStringWidth() <= width) {
            lines.add(fieldElement);
            return lines;
        }
        FieldElement element = fieldElement;
        int wordWrapPos = FieldUtils.findWordWrapPosition(element, width);
        while (wordWrapPos > 0) {
            lines.add(element.substring(0, wordWrapPos));
            element = element.substring(wordWrapPos);
            wordWrapPos = FieldUtils.findWordWrapPosition(element, width);
        }
        lines.add(element);
        return lines;
    }

    public static List<FieldElement> wrap(FieldElement fieldElement, int width, boolean breakOnWhiteSpace) {
        if (breakOnWhiteSpace) {
            return FieldUtils.wrap(fieldElement, width);
        }
        ArrayList<FieldElement> lines = new ArrayList<FieldElement>();
        if (fieldElement.getStringWidth() <= width) {
            lines.add(fieldElement);
            return lines;
        }
        FieldElement element = fieldElement;
        int wordWrapPos = element.getMaxCharactersForWidth(width);
        if (wordWrapPos == element.length()) {
            wordWrapPos = 0;
        }
        while (wordWrapPos > 0) {
            lines.add(element.substring(0, wordWrapPos));
            if ((wordWrapPos = (element = element.substring(wordWrapPos)).getMaxCharactersForWidth(width)) != element.length()) continue;
            wordWrapPos = 0;
        }
        lines.add(element);
        return lines;
    }

    private static int findWordWrapPosition(FieldElement element, int width) {
        String text = element.getText();
        int wrapPosition = element.getMaxCharactersForWidth(width);
        if (wrapPosition == element.length() || wrapPosition == 0) {
            return 0;
        }
        int whiteSpacePosition = text.lastIndexOf(" ", wrapPosition - 1);
        if (whiteSpacePosition >= 0) {
            return whiteSpacePosition + 1;
        }
        return wrapPosition;
    }

    public static String trimString(String string) {
        StringBuilder buffer = new StringBuilder(string);
        if (Character.isJavaIdentifierPart(buffer.charAt(0))) {
            for (int index = 1; index < buffer.length(); ++index) {
                char charAt = buffer.charAt(index);
                if (Character.isJavaIdentifierPart((int)charAt)) continue;
                return buffer.substring(0, index);
            }
            return buffer.toString();
        }
        int index = 0;
        char charAt = buffer.charAt(index);
        while (!Character.isJavaIdentifierPart((int)charAt) && buffer.length() > 0) {
            buffer.deleteCharAt(0);
            charAt = buffer.charAt(0);
        }
        index = buffer.length() - 1;
        charAt = buffer.charAt(index);
        while (!Character.isJavaIdentifierPart((int)charAt) && index > 0) {
            buffer.deleteCharAt(index);
            charAt = buffer.charAt(--index);
        }
        return buffer.toString();
    }
}

