/*
 * Decompiled with CFR 0.152.
 */
package docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;

public class CloseIcon
implements Icon {
    private int size;
    private Color color;
    private Shape shape;

    public CloseIcon(boolean isSmall, Color color) {
        this.size = isSmall ? 8 : 16;
        this.color = color;
        this.shape = this.buildShape();
    }

    private Shape buildShape() {
        GeneralPath path = new GeneralPath();
        double margin = 2.0;
        double shapeSize = 11.0;
        double thickness = 1.7;
        if (this.size == 8) {
            margin = 0.0;
            shapeSize = 7.0;
            thickness = 1.0;
        }
        double p1x = margin;
        double p1y = margin + thickness;
        double p2x = margin + thickness;
        double p2y = margin;
        double p3x = margin + shapeSize;
        double p3y = margin + shapeSize - thickness;
        double p4x = margin + shapeSize - thickness;
        double p4y = margin + shapeSize;
        path.moveTo(p1x, p1y);
        path.lineTo(p2x, p2y);
        path.lineTo(p3x, p3y);
        path.lineTo(p4x, p4y);
        path.lineTo(p1x, p1y);
        p1x = margin + shapeSize - thickness;
        p1y = margin;
        p2x = margin + shapeSize;
        p2y = margin + thickness;
        p3x = margin + thickness;
        p3y = margin + shapeSize;
        p4x = margin;
        p4y = margin + shapeSize - thickness;
        path.moveTo(p1x, p1y);
        path.lineTo(p2x, p2y);
        path.lineTo(p3x, p3y);
        path.lineTo(p4x, p4y);
        path.lineTo(p1x, p1y);
        path.closePath();
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            g2d.translate(x, y);
            g2d.setColor(this.color);
            g2d.fill(this.shape);
        }
        finally {
            g2d.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

