/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.boot;

import com.nqzero.permit.Permit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.rzo.yajsw.app.WrapperJVMMain;
import org.rzo.yajsw.boot.WrapperClassLoader;

public class WrapperLoader {
    private static boolean checkPath(String path) {
        int ix = path.indexOf("!");
        return ix != -1;
    }

    public static String getWrapperJar() {
        String wrapperJar = System.getProperty("wrapper.wrapperJar", null);
        if (wrapperJar != null && new File(wrapperJar).exists()) {
            return wrapperJar;
        }
        try {
            return WrapperLoader.getJarFile(WrapperLoader.class.getClassLoader().loadClass("org.rzo.yajsw.Constants"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWrapperAppJar() {
        String appJar = System.getProperty("wrapper.appJar", null);
        if (appJar != null && new File(appJar).exists()) {
            return appJar;
        }
        return WrapperLoader.getJarFile(WrapperJVMMain.class);
    }

    public static String getPermitJar() {
        String appJar = System.getProperty("wrapper.permitJar", null);
        if (appJar != null && new File(appJar).exists()) {
            return appJar;
        }
        return WrapperLoader.getJarFile(Permit.class);
    }

    private static String getJarFile(Class clazz) {
        String cn = clazz.getCanonicalName();
        String rn = cn.replace('.', '/') + ".class";
        String path = ".";
        try {
            path = clazz.getClassLoader().getResource(rn).getPath();
            if (!WrapperLoader.checkPath(path)) {
                return null;
            }
            File f = (path = path.substring(0, path.indexOf("!"))).startsWith("file:") ? new File(new URI(path)) : new File(path);
            return f.getCanonicalPath();
        }
        catch (Exception e1) {
            System.out.println(path);
            e1.printStackTrace();
            return null;
        }
    }

    public static ArrayList getGroovyClasspath() {
        File[] groovyLibs;
        ArrayList<URL> result = new ArrayList<URL>();
        String wrapperHome = WrapperLoader.getWrapperHome();
        File groovyLib = new File(wrapperHome, "lib");
        if (!groovyLib.exists()) {
            System.out.println("<yajsw>/lib folder not found. Please check that relative the lib folder is in the same folder as <yajsw>/wrapper.jar");
            return result;
        }
        for (File file : groovyLibs = groovyLib.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(WrapperLoader.getFiles(file));
                continue;
            }
            try {
                result.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                System.out.println("Error in getGroovyClasspath: " + e.getMessage());
            }
        }
        return result;
    }

    private static Collection getFiles(File parent) {
        File[] files;
        ArrayList<URL> result = new ArrayList<URL>();
        for (File file : files = parent.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(WrapperLoader.getFiles(file));
                continue;
            }
            try {
                result.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                System.out.println("Error in getGroovyClasspath: " + e.getMessage());
            }
        }
        return result;
    }

    public static URL[] getWrapperClasspath(String type, boolean logErrors) {
        Manifest manifest;
        String wrapperJar = type.contains("App") ? WrapperLoader.getWrapperAppJar() : WrapperLoader.getWrapperJar();
        if (wrapperJar == null) {
            System.out.println("<yajsw>/wrapper.jar not found, please check classpath. aborting wrapper !");
            Runtime.getRuntime().halt(999);
        }
        try {
            manifest = new JarFile(wrapperJar).getManifest();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        Attributes attr = manifest.getMainAttributes();
        String cl = attr.getValue("Class-Path-" + type);
        if (cl == null) {
            return null;
        }
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.add(new File(wrapperJar));
        String[] clArr = cl.split(" ");
        File parent = new File(wrapperJar).getParentFile();
        for (int i = 0; i < clArr.length; ++i) {
            String file = clArr[i];
            try {
                File myFile = new File(parent, file);
                if (!myFile.exists()) {
                    if (!logErrors) continue;
                    System.out.println("WARNING: lib not found: " + myFile.getCanonicalPath());
                    continue;
                }
                classpath.add(myFile);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ("App".equals(type) && WrapperLoader.requiredRTjar()) {
            try {
                String rt = WrapperLoader.getRTJar();
                if (rt != null) {
                    File rtf = new File(rt);
                    if (!rtf.exists()) {
                        System.out.println("could not find rt.jar");
                    } else {
                        classpath.add(rtf);
                    }
                } else {
                    System.out.println("could not find rt.jar");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        URL[] urlsArr = new URL[classpath.size()];
        int i = 0;
        Iterator it = classpath.iterator();
        while (it.hasNext()) {
            try {
                urlsArr[i] = ((File)it.next()).toURI().toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return urlsArr;
    }

    public static boolean requiredRTjar() {
        String jvm = System.getProperty("java.version");
        return jvm.startsWith("1.");
    }

    public static URLClassLoader getWrapperClassLoader() {
        URL[] core = WrapperLoader.getWrapperClasspath("Wrapper-Core", true);
        URL[] extended = WrapperLoader.getWrapperClasspath("Wrapper-Extended", false);
        URL[] urls = new URL[core.length + extended.length];
        System.arraycopy(core, 0, urls, 0, core.length);
        System.arraycopy(extended, 0, urls, core.length, extended.length);
        return new WrapperClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    public static String getWrapperHome() {
        return new File(WrapperLoader.getWrapperJar()).getParent();
    }

    public static String getRTJar() {
        String cn = Object.class.getCanonicalName();
        String rn = cn.replace('.', '/') + ".class";
        String path = ".";
        try {
            path = WrapperJVMMain.class.getClassLoader().getResource(rn).getPath();
            if (!WrapperLoader.checkPath(path)) {
                return null;
            }
            path = path.substring(0, path.indexOf("!"));
            path = new URI(path).getPath();
            path.replaceAll("%20", " ");
            return path;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(WrapperLoader.getWrapperAppJar());
        System.out.println(WrapperLoader.getWrapperApp9Jar());
    }

    public static String getWrapperApp9Jar() {
        String appJar = WrapperLoader.getWrapperAppJar();
        String result = appJar.substring(0, appJar.length() - 4) + "9.jar";
        return result;
    }
}

