/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftExtensionNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled namespace = null;
        Demangled type = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Module: {
                    namespace = child.demangle(demangler);
                    namespace.setName("(extension_" + namespace.getName() + ")");
                    continue block4;
                }
                case Class: 
                case Enum: 
                case Protocol: 
                case Structure: {
                    type = child.demangle(demangler);
                    continue block4;
                }
            }
            this.skip(child);
        }
        if (type == null || namespace == null) {
            return this.getUnknown();
        }
        Demangled typeNamespace = type.getNamespace();
        if (typeNamespace != null) {
            typeNamespace.setNamespace(namespace);
        } else {
            type.setNamespace(namespace);
        }
        return type;
    }
}

