/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.features.bsim.query.protocol.QueryUpdate;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResponseUpdate
extends QueryResponseRecord {
    public List<ExecutableRecord> badexe = new ArrayList<ExecutableRecord>();
    public List<FunctionDescription> badfunc = new ArrayList<FunctionDescription>();
    public int exeupdate = 0;
    public int funcupdate = 0;
    public QueryUpdate qupdate;

    public ResponseUpdate(QueryUpdate q) {
        super("responseupdate");
        this.qupdate = q;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        this.qupdate.manage.populateExecutableXref();
        fwrite.append('<').append(this.name).append(">\n");
        for (ExecutableRecord exe : this.badexe) {
            fwrite.append("<badexe id=\"");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)exe.getXrefIndex()));
            fwrite.append("\">\n");
        }
        for (FunctionDescription func : this.badfunc) {
            fwrite.append("<badfunc id=\"");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)func.getExecutableRecord().getXrefIndex()));
            fwrite.append("\" name=\"");
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)func.getFunctionName());
            fwrite.append("\" addr=\"");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)func.getAddress()));
            fwrite.append("\">\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        DescriptionManager manage = this.qupdate.manage;
        Map<Integer, ExecutableRecord> exeMap = manage.generateExecutableXrefMap();
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            if (el.getName().equals("badexe")) {
                id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
                ExecutableRecord exe = exeMap.get(id);
                this.badexe.add(exe);
            } else if (el.getName().equals("badfunc")) {
                id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
                long address = SpecXmlUtils.decodeLong((String)el.getAttribute("addr"));
                ExecutableRecord exe = exeMap.get(id);
                FunctionDescription func = manage.findFunction(el.getAttribute("name"), address, exe);
                this.badfunc.add(func);
            }
            parser.end();
        }
    }
}

