/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.PowerPC_ElfExtension;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.PowerPC_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.PowerPC_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import java.util.Map;

public class PowerPC_ElfRelocationHandler
extends AbstractElfRelocationHandler<PowerPC_ElfRelocationType, PowerPC_ElfRelocationContext> {
    private static final int PPC_WORD32 = -1;
    private static final int PPC_WORD30 = -4;
    private static final int PPC_LOW24 = 0x3FFFFFC;
    private static final int PPC_LOW14 = 2162684;
    private static final int PPC_HALF16 = 65535;

    public PowerPC_ElfRelocationHandler() {
        super(PowerPC_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 20 && elf.is32Bit();
    }

    public PowerPC_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new PowerPC_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    public int getRelrRelocationType() {
        return PowerPC_ElfRelocationType.R_PPC_RELATIVE.typeId;
    }

    protected RelocationResult relocate(PowerPC_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, PowerPC_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int symbolIndex = relocation.getSymbolIndex();
        int addend = (int)relocation.getAddend();
        long relocbase = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int newValue = 0;
        int byteLength = 4;
        switch (type) {
            case R_PPC_RELATIVE: {
                newValue = (int)relocbase + addend;
                memory.setInt(relocationAddress, newValue);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_PPC_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        int offset = (int)relocationAddress.getOffset();
        int oldValue = memory.getInt(relocationAddress);
        switch (type) {
            case R_PPC_ADDR32: 
            case R_PPC_UADDR32: 
            case R_PPC_GLOB_DAT: {
                newValue = (int)symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                if (symbolIndex == 0 || addend == 0 || sym.isSection()) break;
                PowerPC_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                PowerPC_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_PPC_ADDR24: {
                newValue = (int)symbolValue + addend >> 2;
                newValue = oldValue & 0xFC000003 | newValue << 2;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_PPC_ADDR16: 
            case R_PPC_UADDR16: {
                newValue = (int)symbolValue + addend;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case R_PPC_ADDR16_LO: {
                if (Long.compareUnsigned(symbolValue, relocbase) > 0 && Long.compareUnsigned(symbolValue, relocbase + (long)addend) <= 0) {
                    symbolValue = (int)relocbase;
                }
                newValue = (int)(symbolValue + (long)addend);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case R_PPC_ADDR16_HI: {
                newValue = (int)symbolValue + addend >> 16;
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case R_PPC_ADDR16_HA: {
                if (Long.compareUnsigned(symbolValue, relocbase) > 0 && Long.compareUnsigned(symbolValue, relocbase + (long)addend) <= 0) {
                    symbolValue = (int)relocbase;
                }
                newValue = (newValue >> 16) + (((newValue = (int)(symbolValue + (long)addend)) & 0x8000) != 0 ? 1 : 0);
                memory.setShort(relocationAddress, (short)newValue);
                byteLength = 2;
                break;
            }
            case R_PPC_ADDR14: 
            case R_PPC_ADDR14_BRTAKEN: 
            case R_PPC_ADDR14_BRNTAKEN: {
                newValue = (int)symbolValue + addend >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x3FFFFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_PPC_REL24: {
                newValue = (int)symbolValue + addend - offset >> 2;
                newValue = newValue << 2 & 0x3FFFFFC;
                newValue = oldValue & 0xFC000003 | newValue;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_PPC_REL32: {
                newValue = (int)symbolValue + addend - offset;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_PPC_REL14: 
            case R_PPC_REL14_BRTAKEN: 
            case R_PPC_REL14_BRNTAKEN: {
                newValue = (int)symbolValue + addend - offset >> 2;
                newValue = oldValue & 0xFFDF0003 | newValue << 2 & 0x20FFFC;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case R_PPC_JMP_SLOT: {
                int value = (int)symbolValue + addend;
                ElfDynamicTable dynamicTable = elfRelocationContext.getElfHeader().getDynamicTable();
                if (dynamicTable != null && dynamicTable.containsDynamicValue(PowerPC_ElfExtension.DT_PPC_GOT)) {
                    memory.setInt(relocationAddress, value);
                    break;
                }
                int displacement = value - offset;
                if (displacement << 6 >> 6 == displacement) {
                    newValue = 0x48000000 | displacement & 0x3FFFFFC;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                if (value > 0 && value <= 0x1FFFFFC || value < 0 && value >= -33554432) {
                    newValue = 0x48000002 | value & 0x3FFFFFC;
                    memory.setInt(relocationAddress, newValue);
                    break;
                }
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.FAILURE;
            }
            case R_PPC_EMB_SDA21: {
                long alignedRelocOffset = relocationAddress.getOffset() & 0xFFFFFFFFFFFFFFFCL;
                relocationAddress = relocationAddress.getNewAddress(alignedRelocOffset);
                oldValue = memory.getInt(relocationAddress);
                MemoryBlock block = memory.getBlock(symbolAddr);
                Integer sdaBase = null;
                Integer gprID = null;
                if (block != null) {
                    String blockName = block.getName();
                    if (".sdata".equals(blockName) || ".sbss".equals(blockName)) {
                        sdaBase = elfRelocationContext.getSDABase();
                        gprID = 13;
                    } else if (".sdata2".equals(blockName) || ".sbss2".equals(blockName)) {
                        sdaBase = elfRelocationContext.getSDA2Base();
                        gprID = 2;
                    } else if (".PPC.EMB.sdata0".equals(blockName) || ".PPC.EMB.sbss0".equals(blockName)) {
                        sdaBase = 0;
                        gprID = 0;
                    } else if ("EXTERNAL".equals(blockName)) {
                        this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Unsupported relocation for external symbol", elfRelocationContext.getLog());
                        return RelocationResult.FAILURE;
                    }
                }
                if (gprID == null || sdaBase == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to identfy appropriate data block", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue = (int)symbolValue - sdaBase + addend & 0xFFFF;
                newValue |= gprID << 16;
                memory.setInt(relocationAddress, newValue |= oldValue & 0xFFE00000);
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

