/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import generic.stl.Pair;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.SarifUtils;
import sarif.export.SarifWriterTask;
import sarif.export.mm.SarifMemoryMapWriter;
import sarif.managers.MemoryMapBytesFile;
import sarif.managers.ProgramSarifMgr;
import sarif.managers.RangeBlock;
import sarif.managers.SarifMgr;

public class MemoryMapSarifMgr
extends SarifMgr {
    public static String KEY = "MEMORY_MAP";
    public static String SUBKEY = "MemorySection";
    private ProgramSarifMgr programMgr;
    private MemoryMapBytesFile bf;

    MemoryMapSarifMgr(ProgramSarifMgr programMgr, Program program, MessageLog log) {
        super(KEY, program, log);
        this.programMgr = programMgr;
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        try {
            this.processMemoryBlock(result, this.programMgr.getDirectory(), this.program, monitor);
            return true;
        }
        catch (AddressOverflowException | FileNotFoundException e) {
            this.log.appendException(e);
            return false;
        }
    }

    private void processMemoryBlock(Map<String, Object> result, String directory, Program program, TaskMonitor monitor) throws FileNotFoundException, AddressOverflowException {
        String name = (String)result.get("name");
        AddressSet set = SarifUtils.getLocations(result, program, null);
        Address blockAddress = set.getMinAddress();
        if (set.getNumAddressRanges() != 1) {
            throw new RuntimeException("Unexpected number of ranges for block @ " + String.valueOf(blockAddress) + ": " + set.getNumAddressRanges());
        }
        int length = (int)set.getMaxAddress().subtract(blockAddress) + 1;
        String permissions = (String)result.get("kind");
        if (permissions == null) {
            permissions = "r";
        }
        boolean r = permissions.indexOf("r") >= 0;
        boolean w = permissions.indexOf("w") >= 0;
        boolean x = permissions.indexOf("x") >= 0;
        boolean isVolatile = (Boolean)result.get("isVolatile");
        boolean isArtificial = (Boolean)result.get("isArtificial");
        String comment = (String)result.get("comment");
        String type = (String)result.get("type");
        String loc = (String)result.get("location");
        try {
            MemoryBlock block = null;
            if (type.equals("DEFAULT")) {
                if (loc == null) {
                    block = MemoryBlockUtils.createUninitializedBlock((Program)program, (boolean)false, (String)name, (Address)blockAddress, (long)length, (String)comment, null, (boolean)r, (boolean)w, (boolean)x, (MessageLog)this.log);
                } else {
                    String[] split = loc.split(":");
                    String fileName = split[0];
                    int fileOffset = Integer.parseInt(split[1]);
                    byte[] bytes = this.setData(directory, fileName, fileOffset, length, this.log);
                    block = MemoryBlockUtils.createInitializedBlock((Program)program, (boolean)false, (String)name, (Address)blockAddress, (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, (String)comment, null, (boolean)r, (boolean)w, (boolean)x, (MessageLog)this.log, (TaskMonitor)monitor);
                }
            } else if (type.equals("BIT_MAPPED")) {
                Address sourceAddr = this.factory.getAddress(loc);
                block = MemoryBlockUtils.createBitMappedBlock((Program)program, (String)name, (Address)blockAddress, (Address)sourceAddr, (int)length, (String)comment, (String)comment, (boolean)r, (boolean)w, (boolean)x, (boolean)false, (MessageLog)this.log);
            } else if (type.equals("BYTE_MAPPED")) {
                Address sourceAddr = this.factory.getAddress(loc);
                block = MemoryBlockUtils.createByteMappedBlock((Program)program, (String)name, (Address)blockAddress, (Address)sourceAddr, (int)length, (String)comment, (String)comment, (boolean)r, (boolean)w, (boolean)x, (boolean)false, (MessageLog)this.log);
            } else {
                throw new RuntimeException("Unexpected type value - " + type);
            }
            if (block != null) {
                block.setVolatile(isVolatile);
                block.setArtificial(isArtificial);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }

    private byte[] setData(String directory, String fileName, int fileOffset, int length, MessageLog log) throws IOException {
        byte[] bytes = new byte[length];
        Arrays.fill(bytes, (byte)-1);
        File f = new File(directory, fileName);
        try (RandomAccessFile binfile = new RandomAccessFile(f, "r");){
            int readLen;
            for (int pos = 0; pos < length; pos += readLen) {
                readLen = 524288;
                if (readLen + pos > length) {
                    readLen = length - pos;
                }
                binfile.seek(fileOffset + pos);
                readLen = binfile.read(bytes, pos, readLen);
                if (readLen > 0) continue;
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.appendMsg("Read exceeded array length " + length);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(JsonArray results, AddressSetView addrs, TaskMonitor monitor, boolean isWriteContents, String filePath) throws IOException, CancelledException {
        monitor.setMessage("Writing MEMORY MAP ...");
        ArrayList<Pair<AddressRange, MemoryBlock>> request = new ArrayList<Pair<AddressRange, MemoryBlock>>();
        AddressRangeIterator iter = addrs.getAddressRanges();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            AddressRange ranges = (AddressRange)iter.next();
            RangeBlock rb = new RangeBlock(this.program.getAddressFactory(), this.program.getMemory(), ranges);
            for (int i = 0; i < rb.getRanges().length; ++i) {
                AddressRange range = rb.getRanges()[i];
                MemoryBlock block = rb.getBlocks()[i];
                request.add((Pair<AddressRange, MemoryBlock>)new Pair((Object)range, (Object)block));
            }
        }
        try {
            this.bf = isWriteContents ? new MemoryMapBytesFile(this.program, filePath) : null;
            MemoryMapSarifMgr.writeAsSARIF(request, this.bf, isWriteContents, results);
        }
        finally {
            if (isWriteContents) {
                this.bf.close();
            }
        }
    }

    public static void writeAsSARIF(List<Pair<AddressRange, MemoryBlock>> request, MemoryMapBytesFile bytes, boolean isWriteContents, JsonArray results) throws IOException {
        SarifMemoryMapWriter writer = new SarifMemoryMapWriter(request, null, bytes, isWriteContents);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

