/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;

public class BytesFieldLocation
extends CodeUnitLocation {
    public BytesFieldLocation(Program program, Address addr, Address byteAddress, int[] componentPath, int columnInByte) {
        super(program, addr, byteAddress, componentPath, 0, 0, columnInByte);
    }

    public BytesFieldLocation(Program program, Address addr) {
        super(program, addr, BytesFieldLocation.getComponentPath(program, addr), 0, 0, 0);
    }

    private static int[] getComponentPath(Program program, Address addr) {
        CodeUnit cu = program.getListing().getCodeUnitContaining(addr);
        if (cu instanceof Data) {
            Data data = (Data)cu;
            Data subData = data.getPrimitiveAt((int)addr.subtract(data.getAddress()));
            return subData != null ? subData.getComponentPath() : data.getComponentPath();
        }
        return null;
    }

    public BytesFieldLocation() {
    }

    public int getByteIndex() {
        return (int)this.getByteAddress().subtract(this.getAddress());
    }

    @Override
    public int getColumn() {
        return this.getByteIndex();
    }

    public int getColumnInByte() {
        return this.getCharOffset();
    }

    public Address getAddressForByte() {
        return this.getAddress().add(this.getByteIndex());
    }
}

