/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class AddressSourceInfo {
    private Address address;
    private MemoryBlock block;
    private FileBytes fileBytes;
    private MemoryBlockSourceInfo sourceInfo;
    private AddressSourceInfo mappedInfo;
    private Memory memory;

    public AddressSourceInfo(Memory memory, Address address, MemoryBlock block) {
        this.memory = memory;
        this.address = address;
        this.block = block;
        this.sourceInfo = this.getContainingInfo();
        this.fileBytes = this.sourceInfo.getFileBytes().orElse(null);
    }

    public Address getAddress() {
        return this.address;
    }

    public long getFileOffset() {
        if (this.mappedInfo != null) {
            return this.mappedInfo.getFileOffset();
        }
        if (this.fileBytes != null) {
            return this.sourceInfo.getFileBytesOffset(this.address) + this.fileBytes.getFileOffset();
        }
        return -1L;
    }

    public String getFileName() {
        if (this.mappedInfo != null) {
            return this.mappedInfo.getFileName();
        }
        if (this.fileBytes != null) {
            return this.fileBytes.getFilename();
        }
        return null;
    }

    public byte getOriginalValue() throws IOException {
        if (this.mappedInfo != null) {
            return this.mappedInfo.getOriginalValue();
        }
        if (this.fileBytes != null) {
            return this.fileBytes.getOriginalByte(this.getFileOffset());
        }
        return 0;
    }

    public MemoryBlockSourceInfo getMemoryBlockSourceInfo() {
        return this.sourceInfo;
    }

    private MemoryBlockSourceInfo getContainingInfo() {
        List<MemoryBlockSourceInfo> sourceInfos = this.block.getSourceInfos();
        for (MemoryBlockSourceInfo info : sourceInfos) {
            if (!info.contains(this.address)) continue;
            Optional<AddressRange> mappedRangeOptional = info.getMappedRange();
            if (mappedRangeOptional.isPresent()) {
                this.mappedInfo = this.getMappedSourceInfo(info, mappedRangeOptional.get());
            }
            return info;
        }
        return null;
    }

    private AddressSourceInfo getMappedSourceInfo(MemoryBlockSourceInfo info, AddressRange addressRange) {
        Address mappedAddress = addressRange.getMinAddress().add(this.address.subtract(info.getMinAddress()));
        MemoryBlock mappedBlock = this.memory.getBlock(mappedAddress);
        if (mappedBlock == null) {
            return null;
        }
        return new AddressSourceInfo(this.memory, mappedAddress, mappedBlock);
    }
}

