/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.framework.model.TransactionInfo;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class SetMatchTagTask
extends Task {
    protected final List<VTMatch> matches;
    private final VTSessionDB sessionDB;
    private final VTMatchTag tag;

    public SetMatchTagTask(VTSession session, List<VTMatch> matches, VTMatchTag tag) {
        super("Set Match Tag", true, true, true, true);
        this.tag = tag;
        if (!(session instanceof VTSessionDB)) {
            throw new IllegalArgumentException("Unexpected condition - VTSession is not a DB object!");
        }
        this.sessionDB = (VTSessionDB)session;
        this.matches = matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        if (this.hasTransactionsOpen()) {
            return;
        }
        boolean commit = true;
        int matchSetTransactionID = this.sessionDB.startTransaction(this.getTaskTitle());
        try {
            this.doWork(monitor);
        }
        catch (CancelledException e) {
            commit = false;
        }
        catch (Exception e) {
            commit = false;
            Msg.showError((Object)((Object)this), null, (String)"Unable to Set Match Tag", (Object)"An unexpected error occurred attempting to set match tag.", (Throwable)e);
        }
        finally {
            this.sessionDB.endTransaction(matchSetTransactionID, commit);
        }
    }

    private boolean hasTransactionsOpen() {
        Program program = this.sessionDB.getDestinationProgram();
        TransactionInfo transaction = program.getCurrentTransactionInfo();
        if (transaction != null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Set Match Tag", (Object)("The program \"" + program.getName() + "\"already has a transaction open: " + transaction.getDescription()));
            return true;
        }
        TransactionInfo matchSetTransaction = this.sessionDB.getCurrentTransactionInfo();
        if (matchSetTransaction != null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Set Match Tag", (Object)"Transaction already open for the Match Set Manager ");
            return true;
        }
        return false;
    }

    protected void doWork(TaskMonitor monitor) throws Exception, CancelledException {
        monitor.initialize((long)this.matches.size());
        for (VTMatch match : this.matches) {
            monitor.checkCancelled();
            VTMatchTag currentTag = match.getTag();
            if (!currentTag.equals(this.tag)) {
                match.setTag(this.tag);
            }
            monitor.incrementProgress(1L);
        }
    }
}

