/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedLengthList;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatableNumberListValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.AbstractSVGNumberList;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.dom.svg.SVGNumberItem;
import io.sf.carte.echosvg.parser.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedNumberList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class SVGOMAnimatedNumberList
extends AbstractSVGAnimatedValue
implements SVGAnimatedNumberList {
    protected BaseSVGNumberList baseVal;
    protected AnimSVGNumberList animVal;
    protected boolean changing;
    protected String defaultValue;
    protected boolean emptyAllowed;

    public SVGOMAnimatedNumberList(AbstractElement elt, String ns, String ln, String defaultValue, boolean emptyAllowed) {
        super(elt, ns, ln);
        this.defaultValue = defaultValue;
        this.emptyAllowed = emptyAllowed;
    }

    public SVGNumberList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGNumberList();
        }
        return this.baseVal;
    }

    public SVGNumberList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGNumberList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGNumberList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        SVGNumberList nl = this.getBaseVal();
        int n = nl.getNumberOfItems();
        float[] numbers = new float[n];
        for (int i = 0; i < n; ++i) {
            numbers[i] = nl.getItem(n).getValue();
        }
        return new AnimatableNumberListValue(target, numbers);
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableNumberListValue animNumList = (AnimatableNumberListValue)val;
            if (this.animVal == null) {
                this.animVal = new AnimSVGNumberList();
            }
            this.animVal.setAnimatedValue(animNumList.getNumbers());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public class BaseSVGNumberList
    extends AbstractSVGNumberList {
        protected boolean missing;
        protected boolean malformed;

        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedNumberList.this.element.createDOMException(type, key, args);
        }

        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedNumberList.this.element).createSVGException(type, key, args);
        }

        protected Element getElement() {
            return SVGOMAnimatedNumberList.this.element;
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedNumberList.this.element.getAttributeNodeNS(SVGOMAnimatedNumberList.this.namespaceURI, SVGOMAnimatedNumberList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedNumberList.this.defaultValue;
            }
            return attr.getValue();
        }

        protected void setAttributeValue(String value) {
            try {
                SVGOMAnimatedNumberList.this.changing = true;
                SVGOMAnimatedNumberList.this.element.setAttributeNS(SVGOMAnimatedNumberList.this.namespaceURI, SVGOMAnimatedNumberList.this.localName, value);
            }
            finally {
                SVGOMAnimatedNumberList.this.changing = false;
            }
        }

        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        protected void resetAttribute(SVGItem item) {
            super.resetAttribute(item);
            this.missing = false;
            this.malformed = false;
        }

        protected void revalidate() {
            boolean isEmpty;
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String s = this.getValueAsString();
            boolean bl = isEmpty = s != null && s.length() == 0;
            if (s == null || isEmpty && !SVGOMAnimatedNumberList.this.emptyAllowed) {
                this.missing = true;
                return;
            }
            if (isEmpty) {
                this.itemList = new ArrayList(1);
            } else {
                try {
                    ListBuilder builder = new ListBuilder((AbstractSVGList)this);
                    this.doParse(s, (ListHandler)builder);
                    if (builder.getList() != null) {
                        this.clear(this.itemList);
                    }
                    this.itemList = builder.getList();
                }
                catch (ParseException e) {
                    this.itemList = new ArrayList(1);
                    this.valid = true;
                    this.malformed = true;
                }
            }
        }

        public void copyTo(AbstractSVGList list) {
            super.copyTo(list);
            SVGOMAnimatedLengthList.BaseSVGLengthList other = (SVGOMAnimatedLengthList.BaseSVGLengthList)list;
            other.malformed = this.malformed;
            other.missing = this.missing;
        }
    }

    protected class AnimSVGNumberList
    extends AbstractSVGNumberList {
        public AnimSVGNumberList() {
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short type, String key, Object[] args) {
            return SVGOMAnimatedNumberList.this.element.createDOMException(type, key, args);
        }

        protected SVGException createSVGException(short type, String key, Object[] args) {
            return ((SVGOMElement)SVGOMAnimatedNumberList.this.element).createSVGException(type, key, args);
        }

        protected Element getElement() {
            return SVGOMAnimatedNumberList.this.element;
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedNumberList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedNumberList.this.getBaseVal().getNumberOfItems();
        }

        public SVGNumber getItem(int index) throws DOMException {
            if (SVGOMAnimatedNumberList.this.hasAnimVal) {
                return super.getItem(index);
            }
            return SVGOMAnimatedNumberList.this.getBaseVal().getItem(index);
        }

        protected String getValueAsString() {
            if (this.itemList.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder(this.itemList.size() * 8);
            Iterator i = this.itemList.iterator();
            if (i.hasNext()) {
                sb.append(((SVGItem)i.next()).getValueAsString());
            }
            while (i.hasNext()) {
                sb.append(this.getItemSeparator());
                sb.append(((SVGItem)i.next()).getValueAsString());
            }
            return sb.toString();
        }

        protected void setAttributeValue(String value) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber initialize(SVGNumber newItem) throws DOMException, SVGException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber insertItemBefore(SVGNumber newItem, int index) throws DOMException, SVGException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber replaceItem(SVGNumber newItem, int index) throws DOMException, SVGException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber removeItem(int index) throws DOMException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        public SVGNumber appendItem(SVGNumber newItem) throws DOMException {
            throw SVGOMAnimatedNumberList.this.element.createDOMException((short)7, "readonly.number.list", null);
        }

        protected void setAnimatedValue(float[] values) {
            int i;
            int size = this.itemList.size();
            for (i = 0; i < size && i < values.length; ++i) {
                SVGNumberItem n = (SVGNumberItem)this.itemList.get(i);
                n.setValue(values[i]);
            }
            while (i < values.length) {
                this.appendItemImpl(new SVGNumberItem(values[i]));
                ++i;
            }
            while (size > values.length) {
                this.removeItemImpl(--size);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem item) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }
}

