/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableCheckConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraintColumn;

public class SQLServerTableCheckConstraint
extends AbstractTableConstraint<SQLServerTable, DBSTableConstraintColumn>
implements SQLServerObject,
DBPScriptObject,
DBSTableCheckConstraint {
    private boolean disabled;
    private String definition;
    private long objectId;

    public SQLServerTableCheckConstraint(SQLServerTable table, JDBCResultSet dbResult) {
        super((DBSTable)table, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name"), null, DBSEntityConstraintType.CHECK);
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.disabled = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_disabled") != 0;
        this.definition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"definition");
    }

    public SQLServerTableCheckConstraint(SQLServerTable table) {
        super((DBSTable)table, null, null, DBSEntityConstraintType.CHECK);
        this.objectId = -1L;
        this.disabled = false;
        this.definition = null;
    }

    @Property(viewable=false, editable=true, order=10)
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)((SQLServerTable)this.getTable()).getDataSource();
    }

    @Property(viewable=false, editable=true, order=80)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, editable=true, length=PropertyLength.MULTILINE, order=20)
    public String getCheckConstraintDefinition() {
        return this.definition;
    }

    public void setCheckConstraintDefinition(String expression) {
        this.definition = expression;
    }

    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return this.getCheckConstraintDefinition();
    }

    @Nullable
    public List<DBSTableConstraintColumn> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public void setAttributeReferences(List<DBSTableConstraintColumn> dbsTableConstraintColumns) throws DBException {
    }

    @Override
    @Nullable
    public SQLServerDatabase getDatabase() {
        return ((SQLServerTable)this.getTable()).getDatabase();
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getTable(), this});
    }
}

