/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch.cluster.stats.ClusterIndices;
import org.opensearch.client.opensearch.cluster.stats.ClusterNodes;
import org.opensearch.client.opensearch.nodes.NodesResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterStatsResponse
extends NodesResponseBase
implements ToCopyableBuilder<Builder, ClusterStatsResponse> {
    @Nonnull
    private final String clusterName;
    @Nonnull
    private final String clusterUuid;
    @Nullable
    private final ClusterIndices indices;
    @Nullable
    private final ClusterNodes nodes;
    @Nonnull
    private final HealthStatus status;
    private final long timestamp;
    public static final JsonpDeserializer<ClusterStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterStatsResponse::setupClusterStatsResponseDeserializer);

    private ClusterStatsResponse(Builder builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.clusterUuid = ApiTypeHelper.requireNonNull(builder.clusterUuid, this, "clusterUuid");
        this.indices = builder.indices;
        this.nodes = builder.nodes;
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static ClusterStatsResponse of(Function<Builder, ObjectBuilder<ClusterStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String clusterName() {
        return this.clusterName;
    }

    @Nonnull
    public final String clusterUuid() {
        return this.clusterUuid;
    }

    @Nullable
    public final ClusterIndices indices() {
        return this.indices;
    }

    @Nullable
    public final ClusterNodes nodes() {
        return this.nodes;
    }

    @Nonnull
    public final HealthStatus status() {
        return this.status;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        if (this.indices != null) {
            generator.writeKey("indices");
            this.indices.serialize(generator, mapper);
        }
        if (this.nodes != null) {
            generator.writeKey("nodes");
            this.nodes.serialize(generator, mapper);
        }
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        ClusterStatsResponse.setupNodesResponseBaseDeserializer(op);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid");
        op.add(Builder::indices, ClusterIndices._DESERIALIZER, "indices");
        op.add(Builder::nodes, ClusterNodes._DESERIALIZER, "nodes");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clusterName.hashCode();
        result = 31 * result + this.clusterUuid.hashCode();
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + Long.hashCode(this.timestamp);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStatsResponse other = (ClusterStatsResponse)o;
        return this.clusterName.equals(other.clusterName) && this.clusterUuid.equals(other.clusterUuid) && Objects.equals(this.indices, other.indices) && Objects.equals(this.nodes, other.nodes) && this.status.equals(other.status) && this.timestamp == other.timestamp;
    }

    public static class Builder
    extends NodesResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ClusterStatsResponse> {
        private String clusterName;
        private String clusterUuid;
        @Nullable
        private ClusterIndices indices;
        @Nullable
        private ClusterNodes nodes;
        private HealthStatus status;
        private Long timestamp;

        public Builder() {
        }

        private Builder(ClusterStatsResponse o) {
            super(o);
            this.clusterName = o.clusterName;
            this.clusterUuid = o.clusterUuid;
            this.indices = o.indices;
            this.nodes = o.nodes;
            this.status = o.status;
            this.timestamp = o.timestamp;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.clusterUuid = o.clusterUuid;
            this.indices = o.indices;
            this.nodes = o.nodes;
            this.status = o.status;
            this.timestamp = o.timestamp;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder clusterUuid(String value) {
            this.clusterUuid = value;
            return this;
        }

        @Nonnull
        public final Builder indices(@Nullable ClusterIndices value) {
            this.indices = value;
            return this;
        }

        @Nonnull
        public final Builder indices(Function<ClusterIndices.Builder, ObjectBuilder<ClusterIndices>> fn) {
            return this.indices(fn.apply(new ClusterIndices.Builder()).build());
        }

        @Nonnull
        public final Builder nodes(@Nullable ClusterNodes value) {
            this.nodes = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Function<ClusterNodes.Builder, ObjectBuilder<ClusterNodes>> fn) {
            return this.nodes(fn.apply(new ClusterNodes.Builder()).build());
        }

        @Nonnull
        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        @Nonnull
        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        @Nonnull
        public ClusterStatsResponse build() {
            this._checkSingleUse();
            return new ClusterStatsResponse(this);
        }
    }
}

