/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.contextmanager;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.contextmanager.ActivationRule;
import org.opensearch.ml.common.contextmanager.ActivationRuleFactory;
import org.opensearch.ml.common.contextmanager.ContextManager;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;

public class ToolsOutputTruncateManager
implements ContextManager {
    @Generated
    private static final Logger log = LogManager.getLogger(ToolsOutputTruncateManager.class);
    public static final String TYPE = "ToolsOutputTruncateManager";
    private static final String MAX_OUTPUT_LENGTH_KEY = "max_output_length";
    private static final int DEFAULT_MAX_OUTPUT_LENGTH = 40000;
    private int maxOutputLength;
    private List<ActivationRule> activationRules;

    public String getType() {
        return TYPE;
    }

    public void initialize(Map<String, Object> config) {
        this.maxOutputLength = this.parseIntegerConfig(config, MAX_OUTPUT_LENGTH_KEY, 40000);
        if (this.maxOutputLength <= 0) {
            log.warn("Invalid max_output_length value: {}, using default {}", (Object)this.maxOutputLength, (Object)40000);
            this.maxOutputLength = 40000;
        }
        Map activationConfig = (Map)config.get("activation");
        this.activationRules = ActivationRuleFactory.createRules((Map)activationConfig);
        log.info("Initialized ToolsOutputTruncateManager: maxOutputLength={}", (Object)this.maxOutputLength);
    }

    public boolean shouldActivate(ContextManagerContext context) {
        if (this.activationRules == null || this.activationRules.isEmpty()) {
            return true;
        }
        for (ActivationRule rule : this.activationRules) {
            if (rule.evaluate(context)) continue;
            log.debug("Activation rule not satisfied: {}", (Object)rule.getDescription());
            return false;
        }
        log.debug("All activation rules satisfied, manager will execute");
        return true;
    }

    public void execute(ContextManagerContext context) {
        Map parameters = context.getParameters();
        if (parameters == null) {
            log.debug("No parameters available for tool output truncation");
            return;
        }
        Object currentToolOutput = parameters.get("_current_tool_output");
        if (currentToolOutput == null) {
            log.debug("No current tool output to process");
            return;
        }
        String outputString = currentToolOutput.toString();
        int originalLength = outputString.length();
        if (originalLength <= this.maxOutputLength) {
            log.debug("Tool output length ({}) is within limit ({}), no truncation needed", (Object)originalLength, (Object)this.maxOutputLength);
            return;
        }
        Object truncatedOutput = outputString.substring(0, this.maxOutputLength);
        truncatedOutput = (String)truncatedOutput + "... [Output truncated - original length: " + originalLength + " characters]";
        parameters.put("_current_tool_output", truncatedOutput);
        int truncatedLength = ((String)truncatedOutput).length();
        log.info("Tool output truncated: original length {} -> truncated length {}", (Object)originalLength, (Object)truncatedLength);
    }

    private int parseIntegerConfig(Map<String, Object> config, String key, int defaultValue) {
        Object value = config.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
            log.warn("Invalid type for config key '{}': {}, using default {}", (Object)key, (Object)value.getClass().getSimpleName(), (Object)defaultValue);
            return defaultValue;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid integer value for config key '{}': {}, using default {}", (Object)key, value, (Object)defaultValue);
            return defaultValue;
        }
    }
}

