/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RepositorySettings
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RepositorySettings> {
    @Nullable
    private final String chunkSize;
    @Nullable
    private final Boolean compress;
    @Nullable
    private final Integer concurrentStreams;
    @Nullable
    private final String location;
    @Nullable
    private final Boolean readOnly;
    public static final JsonpDeserializer<RepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositorySettings::setupRepositorySettingsDeserializer);

    private RepositorySettings(Builder builder) {
        this.chunkSize = builder.chunkSize;
        this.compress = builder.compress;
        this.concurrentStreams = builder.concurrentStreams;
        this.location = builder.location;
        this.readOnly = builder.readOnly;
    }

    public static RepositorySettings of(Function<Builder, ObjectBuilder<RepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String chunkSize() {
        return this.chunkSize;
    }

    @Nullable
    public final Boolean compress() {
        return this.compress;
    }

    @Nullable
    public final Integer concurrentStreams() {
        return this.concurrentStreams;
    }

    @Nullable
    public final String location() {
        return this.location;
    }

    @Nullable
    public final Boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkSize != null) {
            generator.writeKey("chunk_size");
            generator.write(this.chunkSize);
        }
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress.booleanValue());
        }
        if (this.concurrentStreams != null) {
            generator.writeKey("concurrent_streams");
            generator.write(this.concurrentStreams.intValue());
        }
        if (this.location != null) {
            generator.writeKey("location");
            generator.write(this.location);
        }
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            generator.write(this.readOnly.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkSize, JsonpDeserializer.stringDeserializer(), "chunk_size");
        op.add(Builder::compress, JsonpDeserializer.booleanDeserializer(), "compress");
        op.add(Builder::concurrentStreams, JsonpDeserializer.integerDeserializer(), "concurrent_streams");
        op.add(Builder::location, JsonpDeserializer.stringDeserializer(), "location");
        op.add(Builder::readOnly, JsonpDeserializer.booleanDeserializer(), "read_only");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.chunkSize);
        result = 31 * result + Objects.hashCode(this.compress);
        result = 31 * result + Objects.hashCode(this.concurrentStreams);
        result = 31 * result + Objects.hashCode(this.location);
        result = 31 * result + Objects.hashCode(this.readOnly);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositorySettings other = (RepositorySettings)o;
        return Objects.equals(this.chunkSize, other.chunkSize) && Objects.equals(this.compress, other.compress) && Objects.equals(this.concurrentStreams, other.concurrentStreams) && Objects.equals(this.location, other.location) && Objects.equals(this.readOnly, other.readOnly);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RepositorySettings> {
        @Nullable
        private String chunkSize;
        @Nullable
        private Boolean compress;
        @Nullable
        private Integer concurrentStreams;
        @Nullable
        private String location;
        @Nullable
        private Boolean readOnly;

        public Builder() {
        }

        private Builder(RepositorySettings o) {
            this.chunkSize = o.chunkSize;
            this.compress = o.compress;
            this.concurrentStreams = o.concurrentStreams;
            this.location = o.location;
            this.readOnly = o.readOnly;
        }

        private Builder(Builder o) {
            this.chunkSize = o.chunkSize;
            this.compress = o.compress;
            this.concurrentStreams = o.concurrentStreams;
            this.location = o.location;
            this.readOnly = o.readOnly;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder chunkSize(@Nullable String value) {
            this.chunkSize = value;
            return this;
        }

        @Nonnull
        public final Builder compress(@Nullable Boolean value) {
            this.compress = value;
            return this;
        }

        @Nonnull
        public final Builder concurrentStreams(@Nullable Integer value) {
            this.concurrentStreams = value;
            return this;
        }

        @Nonnull
        public final Builder location(@Nullable String value) {
            this.location = value;
            return this;
        }

        @Nonnull
        public final Builder readOnly(@Nullable Boolean value) {
            this.readOnly = value;
            return this;
        }

        @Override
        @Nonnull
        public RepositorySettings build() {
            this._checkSingleUse();
            return new RepositorySettings(this);
        }
    }
}

