/*
 * Decompiled with CFR 0.152.
 */
package jiconfont.javafx;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import jiconfont.IconCode;
import jiconfont.IconFont;
import jiconfont.javafx.IconNode;

public class IconFontFX {
    private static List<IconFont> fonts = new ArrayList<IconFont>();

    public static synchronized void register(IconFont iconFont) {
        if (!fonts.contains(iconFont)) {
            Font.loadFont((InputStream)iconFont.getFontInputStream(), (double)0.0);
            fonts.add(iconFont);
        }
    }

    public static Image buildImage(IconCode iconCode, Number size, Paint fill) {
        return IconFontFX.buildImage(iconCode, size, fill, null);
    }

    public static Image buildImage(IconCode iconCode, Number size, Paint fill, Paint stroke) {
        IconNode iconNode = new IconNode();
        iconNode.setIconCode(iconCode);
        iconNode.setIconSize(size);
        iconNode.setFill(fill);
        iconNode.setStroke(stroke);
        Group group = new Group(new Node[]{iconNode});
        new Scene((Parent)group);
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        return group.snapshot(parameters, null);
    }
}

