/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    private final Icon[] icons;
    private final Axis axis;
    private final int gap;
    private float alignmentX = 0.5f;
    private float alignmentY = 0.5f;

    public CompoundIcon(Icon ... icons) {
        this(Axis.X_AXIS, icons);
    }

    public CompoundIcon(Axis axis, Icon ... icons) {
        this(axis, 0, icons);
    }

    public CompoundIcon(Axis axis, int gap, Icon ... icons) {
        this(axis, gap, 0.5f, 0.5f, icons);
    }

    public CompoundIcon(Axis axis, int gap, float alignmentX, float alignmentY, Icon ... icons) {
        this.axis = axis;
        this.gap = gap;
        this.alignmentX = alignmentX > 1.0f ? 1.0f : Math.max(alignmentX, 0.0f);
        this.alignmentY = alignmentY > 1.0f ? 1.0f : Math.max(alignmentY, 0.0f);
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] != null) continue;
            String message = "Icon (" + i + ") cannot be null";
            throw new IllegalArgumentException(message);
        }
        this.icons = icons;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getGap() {
        return this.gap;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public int getIconCount() {
        return this.icons.length;
    }

    public Icon getIcon(int index) {
        return this.icons[index];
    }

    @Override
    public int getIconWidth() {
        int width = 0;
        if (this.axis == Axis.X_AXIS) {
            width += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                width += icon.getIconWidth();
            }
        } else {
            for (Icon icon : this.icons) {
                width = Math.max(width, icon.getIconWidth());
            }
        }
        return width;
    }

    @Override
    public int getIconHeight() {
        int height = 0;
        if (this.axis == Axis.Y_AXIS) {
            height += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                height += icon.getIconHeight();
            }
        } else {
            for (Icon icon : this.icons) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        return height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.axis == Axis.X_AXIS) {
            int height = this.getIconHeight();
            for (Icon icon : this.icons) {
                int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(c, g, x, y + iconY);
                x += icon.getIconWidth() + this.gap;
            }
        } else if (this.axis == Axis.Y_AXIS) {
            int width = this.getIconWidth();
            for (Icon icon : this.icons) {
                int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                icon.paintIcon(c, g, x + iconX, y);
                y += icon.getIconHeight() + this.gap;
            }
        } else {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            for (Icon icon : this.icons) {
                int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                icon.paintIcon(c, g, x + iconX, y + iconY);
            }
        }
    }

    private int getOffset(int maxValue, int iconValue, float alignment) {
        float offset = (float)(maxValue - iconValue) * alignment;
        return Math.round(offset);
    }

    public static enum Axis {
        X_AXIS,
        Y_AXIS,
        Z_AXIS;

    }
}

