/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.tipis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReplicatedMap<K, V>
extends AbstractReplicatedMap<K, V> {
    private static final long serialVersionUID = 1L;
    private volatile transient Log log;

    public ReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, int n, float f, ClassLoader[] classLoaderArray) {
        super(mapOwner, channel, l, string, n, f, 2, classLoaderArray, true);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, int n, ClassLoader[] classLoaderArray) {
        super(mapOwner, channel, l, string, n, 0.75f, 2, classLoaderArray, true);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, ClassLoader[] classLoaderArray) {
        super(mapOwner, channel, l, string, 16, 0.75f, 2, classLoaderArray, true);
    }

    public ReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, ClassLoader[] classLoaderArray, boolean bl) {
        super(mapOwner, channel, l, string, 16, 0.75f, 2, classLoaderArray, bl);
    }

    @Override
    protected int getStateMessageType() {
        return 10;
    }

    @Override
    protected int getReplicateMessageType() {
        return 9;
    }

    @Override
    protected Member[] publishEntryInfo(Object object, Object object2) throws ChannelException {
        Object[] objectArray;
        block7: {
            if (!(object instanceof Serializable) || !(object2 instanceof Serializable)) {
                return new Member[0];
            }
            objectArray = this.getMapMembers();
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            try {
                AbstractReplicatedMap.MapMessage mapMessage = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 9, false, (Serializable)object, (Serializable)object2, null, this.channel.getLocalMember(false), (Member[])objectArray);
                this.getChannel().send((Member[])objectArray, mapMessage, this.getChannelSendOptions());
            }
            catch (ChannelException channelException) {
                ChannelException.FaultyMember[] faultyMemberArray = channelException.getFaultyMembers();
                if (faultyMemberArray.length == 0) {
                    throw channelException;
                }
                ArrayList<Member> arrayList = new ArrayList<Member>();
                for (ChannelException.FaultyMember faultyMember : faultyMemberArray) {
                    if (faultyMember.getCause() instanceof RemoteProcessException) continue;
                    arrayList.add(faultyMember.getMember());
                }
                Object[] objectArray2 = arrayList.toArray(new Member[0]);
                if (objectArray2.length == 0) break block7;
                if ((objectArray = this.excludeFromSet((Member[])objectArray2, (Member[])objectArray)).length == 0) {
                    throw channelException;
                }
                if (!this.getLog().isWarnEnabled()) break block7;
                this.getLog().warn((Object)sm.getString("replicatedMap.unableReplicate.completely", object, Arrays.toString(objectArray), Arrays.toString(objectArray2)), (Throwable)channelException);
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        boolean bl = false;
        Log log = this.getLog();
        HashMap hashMap = this.mapMembers;
        synchronized (hashMap) {
            boolean bl2 = bl = this.mapMembers.remove(member) != null;
            if (!bl) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("replicatedMap.member.disappeared.unknown", member));
                }
                return;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("replicatedMap.member.disappeared", member));
        }
        long l = System.currentTimeMillis();
        for (Map.Entry entry : this.innerMap.entrySet()) {
            AbstractReplicatedMap.MapMessage mapMessage;
            Member[] memberArray;
            AbstractReplicatedMap.MapEntry mapEntry = (AbstractReplicatedMap.MapEntry)this.innerMap.get(entry.getKey());
            if (mapEntry == null) continue;
            if (mapEntry.isPrimary()) {
                try {
                    memberArray = this.getMapMembers();
                    if (memberArray.length > 0) {
                        mapMessage = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 12, false, (Serializable)mapEntry.getKey(), null, null, this.channel.getLocalMember(false), memberArray);
                        this.getChannel().send(memberArray, mapMessage, this.getChannelSendOptions());
                    }
                    mapEntry.setBackupNodes(memberArray);
                    mapEntry.setPrimary(this.channel.getLocalMember(false));
                }
                catch (ChannelException channelException) {
                    log.error((Object)sm.getString("replicatedMap.unable.relocate", mapEntry.getKey()), (Throwable)channelException);
                }
            } else if (member.equals(mapEntry.getPrimary())) {
                mapEntry.setPrimary(null);
            }
            if (mapEntry.getPrimary() != null || !mapEntry.isCopy() || mapEntry.getBackupNodes() == null || mapEntry.getBackupNodes().length <= 0 || !mapEntry.getBackupNodes()[0].equals(this.channel.getLocalMember(false))) continue;
            try {
                mapEntry.setPrimary(this.channel.getLocalMember(false));
                mapEntry.setBackup(false);
                mapEntry.setProxy(false);
                mapEntry.setCopy(false);
                memberArray = this.getMapMembers();
                if (memberArray.length > 0) {
                    mapMessage = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 12, false, (Serializable)mapEntry.getKey(), null, null, this.channel.getLocalMember(false), memberArray);
                    this.getChannel().send(memberArray, mapMessage, this.getChannelSendOptions());
                }
                mapEntry.setBackupNodes(memberArray);
                if (this.mapOwner == null) continue;
                this.mapOwner.objectMadePrimary(mapEntry.getKey(), mapEntry.getValue());
            }
            catch (ChannelException channelException) {
                log.error((Object)sm.getString("replicatedMap.unable.relocate", mapEntry.getKey()), (Throwable)channelException);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("replicatedMap.relocate.complete", Long.toString(l2)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mapMemberAdded(Member member) {
        if (member.equals(this.getChannel().getLocalMember(false))) {
            return;
        }
        boolean bl = false;
        Object object = this.mapMembers;
        synchronized (object) {
            if (!this.mapMembers.containsKey(member)) {
                this.mapMembers.put(member, System.currentTimeMillis());
                bl = true;
            }
        }
        if (bl) {
            object = this.stateMutex;
            synchronized (object) {
                Member[] memberArray = this.getMapMembers();
                for (Map.Entry entry : this.innerMap.entrySet()) {
                    AbstractReplicatedMap.MapEntry mapEntry = (AbstractReplicatedMap.MapEntry)this.innerMap.get(entry.getKey());
                    if (mapEntry == null || !mapEntry.isPrimary() || this.inSet(member, mapEntry.getBackupNodes())) continue;
                    mapEntry.setBackupNodes(memberArray);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Log getLog() {
        if (this.log == null) {
            ReplicatedMap replicatedMap = this;
            synchronized (replicatedMap) {
                if (this.log == null) {
                    this.log = LogFactory.getLog(ReplicatedMap.class);
                }
            }
        }
        return this.log;
    }
}

