/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLConf;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLConfCmd;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSSLUtil;
import org.apache.tomcat.util.net.openssl.OpenSSLX509Certificate;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLContext
implements SSLContext {
    private static final Base64 BASE64_ENCODER = new Base64(64, new byte[]{10});
    private static final Log log = LogFactory.getLog(OpenSSLContext.class);
    private static final StringManager netSm = StringManager.getManager(AbstractEndpoint.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);
    private static final String defaultProtocol = "TLS";
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----\n";
    private static final Object END_KEY = "\n-----END PRIVATE KEY-----";
    static final CertificateFactory X509_CERT_FACTORY;
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private final List<String> negotiableProtocols;
    private final long aprPool;
    private final long aprGeneration;
    private final AtomicInteger aprPoolDestroyed = new AtomicInteger(0);
    protected final long cctx;
    protected final long ctx;
    private OpenSSLSessionContext sessionContext;
    private X509TrustManager x509TrustManager;
    private String enabledProtocol;
    private boolean initialized = false;

    public OpenSSLContext(SSLHostConfigCertificate sSLHostConfigCertificate, List<String> list) throws SSLException {
        this.sslHostConfig = sSLHostConfigCertificate.getSSLHostConfig();
        this.certificate = sSLHostConfigCertificate;
        this.aprPool = Pool.create((long)0L);
        this.aprGeneration = Library.getGeneration();
        boolean bl = false;
        try {
            OpenSSLConf openSSLConf = this.sslHostConfig.getOpenSslConf();
            if (openSSLConf != null) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("openssl.makeConf"));
                    }
                    this.cctx = SSLConf.make((long)this.aprPool, (int)58);
                }
                catch (Exception exception) {
                    throw new SSLException(sm.getString("openssl.errMakeConf"), exception);
                }
            } else {
                this.cctx = 0L;
            }
            this.sslHostConfig.setOpenSslConfContext(this.cctx);
            int n = 0;
            for (String string : this.sslHostConfig.getEnabledProtocols()) {
                if ("SSLv2Hello".equalsIgnoreCase(string)) continue;
                if ("SSLv2".equalsIgnoreCase(string)) {
                    n |= 1;
                    continue;
                }
                if ("SSLv3".equalsIgnoreCase(string)) {
                    n |= 2;
                    continue;
                }
                if ("TLSv1".equalsIgnoreCase(string)) {
                    n |= 4;
                    continue;
                }
                if ("TLSv1.1".equalsIgnoreCase(string)) {
                    n |= 8;
                    continue;
                }
                if ("TLSv1.2".equalsIgnoreCase(string)) {
                    n |= 0x10;
                    continue;
                }
                if ("TLSv1.3".equalsIgnoreCase(string)) {
                    n |= 0x20;
                    continue;
                }
                if ("all".equalsIgnoreCase(string)) {
                    n |= SSL.SSL_PROTOCOL_ALL;
                    continue;
                }
                throw new Exception(netSm.getString("endpoint.apr.invalidSslProtocol", new Object[]{string}));
            }
            try {
                this.ctx = org.apache.tomcat.jni.SSLContext.make((long)this.aprPool, (int)n, (int)1);
            }
            catch (Exception exception) {
                throw new Exception(netSm.getString("endpoint.apr.failSslContextMake"), exception);
            }
            this.negotiableProtocols = list;
            bl = true;
        }
        catch (Exception exception) {
            throw new SSLException(sm.getString("openssl.errorSSLCtxInit"), exception);
        }
        finally {
            if (!bl) {
                this.destroy();
            }
        }
    }

    public String getEnabledProtocol() {
        return this.enabledProtocol;
    }

    public void setEnabledProtocol(String string) {
        this.enabledProtocol = string == null ? defaultProtocol : string;
    }

    @Override
    public synchronized void destroy() {
        if (this.aprPoolDestroyed.compareAndSet(0, 1) && Library.tryCleanUpLock((long)this.aprGeneration)) {
            try {
                if (this.ctx != 0L) {
                    org.apache.tomcat.jni.SSLContext.free((long)this.ctx);
                }
                if (this.cctx != 0L) {
                    SSLConf.free((long)this.cctx);
                }
                if (this.aprPool != 0L) {
                    Pool.destroy((long)this.aprPool);
                }
            }
            finally {
                Library.returnCleanUpLock();
            }
        }
    }

    protected static boolean checkConf(OpenSSLConf openSSLConf, long l) throws Exception {
        boolean bl = true;
        Iterator<OpenSSLConfCmd> iterator = openSSLConf.getCommands().iterator();
        while (iterator.hasNext()) {
            int n;
            OpenSSLConfCmd openSSLConfCmd;
            OpenSSLConfCmd openSSLConfCmd2 = openSSLConfCmd = iterator.next();
            String string = openSSLConfCmd2.getName();
            String string2 = openSSLConfCmd2.getValue();
            if (string == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{string2}));
                bl = false;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("opensslconf.checkCommand", new Object[]{string, string2}));
            }
            try {
                n = SSLConf.check((long)l, (String)string, (String)string2);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("opensslconf.checkFailed"));
                return false;
            }
            if (n <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{string, string2, Integer.toString(n)}));
                bl = false;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)sm.getString("opensslconf.resultCommand", new Object[]{string, string2, Integer.toString(n)}));
        }
        if (!bl) {
            log.error((Object)sm.getString("opensslconf.checkFailed"));
        }
        return bl;
    }

    protected static boolean applyConf(OpenSSLConf openSSLConf, long l, long l2) throws Exception {
        int n;
        boolean bl = true;
        SSLConf.assign((long)l, (long)l2);
        Iterator<OpenSSLConfCmd> iterator = openSSLConf.getCommands().iterator();
        while (iterator.hasNext()) {
            OpenSSLConfCmd openSSLConfCmd;
            OpenSSLConfCmd openSSLConfCmd2 = openSSLConfCmd = iterator.next();
            String string = openSSLConfCmd2.getName();
            String string2 = openSSLConfCmd2.getValue();
            if (string == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{string2}));
                bl = false;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("opensslconf.applyCommand", new Object[]{string, string2}));
            }
            try {
                n = SSLConf.apply((long)l, (String)string, (String)string2);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("opensslconf.applyFailed"));
                return false;
            }
            if (n <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{string, string2, Integer.toString(n)}));
                bl = false;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)sm.getString("opensslconf.resultCommand", new Object[]{string, string2, Integer.toString(n)}));
        }
        n = SSLConf.finish((long)l);
        if (n <= 0) {
            log.error((Object)sm.getString("opensslconf.finishFailed", new Object[]{Integer.toString(n)}));
            bl = false;
        }
        if (!bl) {
            log.error((Object)sm.getString("opensslconf.applyFailed"));
        }
        return bl;
    }

    @Override
    public synchronized void init(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) {
        if (this.initialized) {
            log.warn((Object)sm.getString("openssl.doubleInit"));
            return;
        }
        try {
            int n;
            Object object;
            if (this.sslHostConfig.getInsecureRenegotiation()) {
                org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)262144);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)262144);
            }
            String string = this.sslHostConfig.getHonorCipherOrder();
            if (string != null) {
                if (Boolean.parseBoolean(string)) {
                    org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)0x400000);
                } else {
                    org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)0x400000);
                }
            }
            if (this.sslHostConfig.getDisableCompression()) {
                org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)131072);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)131072);
            }
            if (this.sslHostConfig.getDisableSessionTickets()) {
                org.apache.tomcat.jni.SSLContext.setOptions((long)this.ctx, (int)16384);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions((long)this.ctx, (int)16384);
            }
            org.apache.tomcat.jni.SSLContext.setCipherSuite((long)this.ctx, (String)this.sslHostConfig.getCiphers());
            this.certificate.setCertificateKeyManager(OpenSSLUtil.chooseKeyManager(keyManagerArray, this.certificate.getCertificateFile() == null));
            this.addCertificate(this.certificate);
            int n2 = 0;
            switch (this.sslHostConfig.getCertificateVerification()) {
                case NONE: {
                    n2 = 0;
                    break;
                }
                case OPTIONAL: {
                    n2 = 1;
                    break;
                }
                case OPTIONAL_NO_CA: {
                    n2 = 3;
                    break;
                }
                case REQUIRED: {
                    n2 = 2;
                }
            }
            org.apache.tomcat.jni.SSLContext.setVerify((long)this.ctx, (int)n2, (int)this.sslHostConfig.getCertificateVerificationDepth());
            if (trustManagerArray != null) {
                this.x509TrustManager = OpenSSLContext.chooseTrustManager(trustManagerArray);
                org.apache.tomcat.jni.SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new CertificateVerifier(){

                    public boolean verify(long l, byte[][] byArray, String string) {
                        X509Certificate[] x509CertificateArray = OpenSSLContext.certificates(byArray);
                        try {
                            OpenSSLContext.this.x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                            return true;
                        }
                        catch (Exception exception) {
                            log.debug((Object)sm.getString("openssl.certificateVerificationFailed"), (Throwable)exception);
                            return false;
                        }
                    }
                });
                object = this.x509TrustManager.getAcceptedIssuers();
                n = ((X509Certificate[])object).length;
                for (int i = 0; i < n; ++i) {
                    X509Certificate x509Certificate = object[i];
                    org.apache.tomcat.jni.SSLContext.addClientCACertificateRaw((long)this.ctx, (byte[])x509Certificate.getEncoded());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("openssl.addedClientCaCert", new Object[]{x509Certificate.toString()}));
                }
            } else {
                org.apache.tomcat.jni.SSLContext.setCACertificate((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificateFile()), (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificatePath()));
            }
            if (this.negotiableProtocols != null && this.negotiableProtocols.size() > 0) {
                object = new ArrayList<String>(this.negotiableProtocols);
                object.add("http/1.1");
                String[] stringArray = object.toArray(new String[0]);
                org.apache.tomcat.jni.SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray, (int)0);
            }
            if ((object = this.sslHostConfig.getOpenSslConf()) != null && this.cctx != 0L) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("openssl.checkConf"));
                }
                try {
                    if (!OpenSSLContext.checkConf((OpenSSLConf)object, this.cctx)) {
                        log.error((Object)sm.getString("openssl.errCheckConf"));
                        throw new Exception(sm.getString("openssl.errCheckConf"));
                    }
                }
                catch (Exception exception) {
                    throw new Exception(sm.getString("openssl.errCheckConf"), exception);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("openssl.applyConf"));
                }
                try {
                    if (!OpenSSLContext.applyConf((OpenSSLConf)object, this.cctx, this.ctx)) {
                        log.error((Object)sm.getString("openssl.errApplyConf"));
                        throw new SSLException(sm.getString("openssl.errApplyConf"));
                    }
                }
                catch (Exception exception) {
                    throw new SSLException(sm.getString("openssl.errApplyConf"), exception);
                }
                n = org.apache.tomcat.jni.SSLContext.getOptions((long)this.ctx);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("SSLv2Hello");
                if ((n & 0x4000000) == 0) {
                    arrayList.add("TLSv1");
                }
                if ((n & 0x10000000) == 0) {
                    arrayList.add("TLSv1.1");
                }
                if ((n & 0x8000000) == 0) {
                    arrayList.add("TLSv1.2");
                }
                if ((n & 0x1000000) == 0) {
                    arrayList.add("SSLv2");
                }
                if ((n & 0x2000000) == 0) {
                    arrayList.add("SSLv3");
                }
                this.sslHostConfig.setEnabledProtocols(arrayList.toArray(new String[0]));
                this.sslHostConfig.setEnabledCiphers(org.apache.tomcat.jni.SSLContext.getCiphers((long)this.ctx));
            }
            this.sessionContext = new OpenSSLSessionContext(this);
            this.sessionContext.setSessionIdContext(org.apache.tomcat.jni.SSLContext.DEFAULT_SESSION_ID_CONTEXT);
            this.sslHostConfig.setOpenSslContext(this.ctx);
            this.initialized = true;
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("openssl.errorSSLCtxInit"), (Throwable)exception);
            this.destroy();
        }
    }

    public void addCertificate(SSLHostConfigCertificate sSLHostConfigCertificate) throws Exception {
        if (sSLHostConfigCertificate.getCertificateFile() != null) {
            String string = null;
            if (sSLHostConfigCertificate.getCertificateKeyPasswordFile() != null) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(SSLHostConfig.adjustRelativePath(sSLHostConfigCertificate.getCertificateKeyPasswordFile())), StandardCharsets.UTF_8));){
                    string = bufferedReader.readLine();
                }
            } else {
                string = sSLHostConfigCertificate.getCertificateKeyPassword();
            }
            org.apache.tomcat.jni.SSLContext.setCertificate((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(sSLHostConfigCertificate.getCertificateFile()), (String)SSLHostConfig.adjustRelativePath(sSLHostConfigCertificate.getCertificateKeyFile()), (String)string, (int)OpenSSLContext.getCertificateIndex(sSLHostConfigCertificate));
            org.apache.tomcat.jni.SSLContext.setCertificateChainFile((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(sSLHostConfigCertificate.getCertificateChainFile()), (boolean)false);
            org.apache.tomcat.jni.SSLContext.setCARevocation((long)this.ctx, (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListFile()), (String)SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListPath()));
        } else {
            X509Certificate[] x509CertificateArray;
            String string = sSLHostConfigCertificate.getCertificateKeyAlias();
            X509KeyManager x509KeyManager = sSLHostConfigCertificate.getCertificateKeyManager();
            if (string == null) {
                string = "tomcat";
            }
            if ((x509CertificateArray = x509KeyManager.getCertificateChain(string)) == null) {
                string = OpenSSLContext.findAlias(x509KeyManager, sSLHostConfigCertificate);
                x509CertificateArray = x509KeyManager.getCertificateChain(string);
            }
            PrivateKey privateKey = x509KeyManager.getPrivateKey(string);
            StringBuilder stringBuilder = new StringBuilder(BEGIN_KEY);
            String string2 = BASE64_ENCODER.encodeToString(privateKey.getEncoded());
            if (string2.endsWith("\n")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuilder.append(string2);
            stringBuilder.append(END_KEY);
            org.apache.tomcat.jni.SSLContext.setCertificateRaw((long)this.ctx, (byte[])x509CertificateArray[0].getEncoded(), (byte[])stringBuilder.toString().getBytes(StandardCharsets.US_ASCII), (int)OpenSSLContext.getCertificateIndex(sSLHostConfigCertificate));
            for (int i = 1; i < x509CertificateArray.length; ++i) {
                org.apache.tomcat.jni.SSLContext.addChainCertificateRaw((long)this.ctx, (byte[])x509CertificateArray[i].getEncoded());
            }
        }
    }

    private static int getCertificateIndex(SSLHostConfigCertificate sSLHostConfigCertificate) {
        int n = sSLHostConfigCertificate.getType() == SSLHostConfigCertificate.Type.RSA || sSLHostConfigCertificate.getType() == SSLHostConfigCertificate.Type.UNDEFINED ? 0 : (sSLHostConfigCertificate.getType() == SSLHostConfigCertificate.Type.EC ? 3 : (sSLHostConfigCertificate.getType() == SSLHostConfigCertificate.Type.DSA ? 1 : 4));
        return n;
    }

    private static String findAlias(X509KeyManager x509KeyManager, SSLHostConfigCertificate sSLHostConfigCertificate) {
        SSLHostConfigCertificate.Type type = sSLHostConfigCertificate.getType();
        String string = null;
        ArrayList<SSLHostConfigCertificate.Type> arrayList = new ArrayList<SSLHostConfigCertificate.Type>();
        if (SSLHostConfigCertificate.Type.UNDEFINED.equals((Object)type)) {
            arrayList.addAll(Arrays.asList(SSLHostConfigCertificate.Type.values()));
            arrayList.remove((Object)SSLHostConfigCertificate.Type.UNDEFINED);
        } else {
            arrayList.add(type);
        }
        Iterator iterator = arrayList.iterator();
        while (string == null && iterator.hasNext()) {
            string = x509KeyManager.chooseServerAlias(((SSLHostConfigCertificate.Type)((Object)iterator.next())).toString(), null, null);
        }
        return string;
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException(sm.getString("openssl.trustManagerMissing"));
    }

    private static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = new OpenSSLX509Certificate(byArray[i]);
        }
        return x509CertificateArray;
    }

    long getSSLContextID() {
        return this.ctx;
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.sessionContext;
    }

    @Override
    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(this.ctx, defaultProtocol, false, this.sessionContext, this.negotiableProtocols != null && this.negotiableProtocols.size() > 0, this.initialized, this.sslHostConfig.getCertificateVerificationDepth(), this.sslHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.OPTIONAL_NO_CA);
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        X509Certificate[] x509CertificateArray = null;
        X509KeyManager x509KeyManager = this.certificate.getCertificateKeyManager();
        if (x509KeyManager != null) {
            if (string == null) {
                string = "tomcat";
            }
            if ((x509CertificateArray = x509KeyManager.getCertificateChain(string)) == null) {
                string = OpenSSLContext.findAlias(x509KeyManager, this.certificate);
                x509CertificateArray = x509KeyManager.getCertificateChain(string);
            }
        }
        return x509CertificateArray;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = null;
        if (this.x509TrustManager != null) {
            x509CertificateArray = this.x509TrustManager.getAcceptedIssuers();
        }
        return x509CertificateArray;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException(sm.getString("openssl.X509FactoryError"), certificateException);
        }
    }
}

