/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.Extension;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.websocket.PerMessageDeflate;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationBuilder;
import org.apache.tomcat.websocket.WsExtension;

public class TransformationFactory {
    private static final TransformationFactory factory = new TransformationFactory();
    private Map<String, TransformationBuilder> builders = new HashMap<String, TransformationBuilder>();

    private TransformationFactory() {
        this.builders.put("permessage-deflate", PerMessageDeflate.BUILDER);
    }

    public static TransformationFactory getInstance() {
        return factory;
    }

    public Transformation create(String string, List<List<Extension.Parameter>> list, boolean bl) {
        TransformationBuilder transformationBuilder = this.builders.get(string);
        if (transformationBuilder != null) {
            return transformationBuilder.build(list, bl);
        }
        return null;
    }

    public void registerExtension(String string, TransformationBuilder transformationBuilder) {
        this.builders.put(string, transformationBuilder);
    }

    public Set<String> getInstalledExtensionNames() {
        return new HashSet<String>(this.builders.keySet());
    }

    public Set<Extension> getInstalledExtensions() {
        HashSet<WsExtension> hashSet = new HashSet<WsExtension>();
        for (String string : this.builders.keySet()) {
            hashSet.add(new WsExtension(string));
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

