/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.Util;
import org.apache.tomcat.util.res.StringManager;

public final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    static final StringManager sm = StringManager.getManager(ApplicationFilterConfig.class);
    private transient Log log = LogFactory.getLog(ApplicationFilterConfig.class);
    private static final List<String> emptyString = Collections.emptyList();
    private final transient Context context;
    private transient Filter filter = null;
    private final FilterDef filterDef;
    private ObjectName oname;

    ApplicationFilterConfig(Context context, FilterDef filterDef) throws ClassCastException, ReflectiveOperationException, ServletException, NamingException, IllegalArgumentException, SecurityException {
        this.context = context;
        this.filterDef = filterDef;
        if (filterDef.getFilter() == null) {
            this.getFilter();
        } else {
            this.filter = filterDef.getFilter();
            context.getInstanceManager().newInstance((Object)this.filter);
            this.initFilter();
        }
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getFilterClass() {
        return this.filterDef.getFilterClass();
    }

    public String getInitParameter(String string) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(string);
    }

    public Enumeration<String> getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return Collections.enumeration(emptyString);
        }
        return Collections.enumeration(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        return "ApplicationFilterConfig[name=" + this.filterDef.getFilterName() + ", filterClass=" + this.filterDef.getFilterClass() + "]";
    }

    public Map<String, String> getFilterInitParameterMap() {
        return Collections.unmodifiableMap(this.filterDef.getParameterMap());
    }

    Filter getFilter() throws ClassCastException, ReflectiveOperationException, ServletException, NamingException, IllegalArgumentException, SecurityException {
        if (this.filter != null) {
            return this.filter;
        }
        String string = this.filterDef.getFilterClass();
        this.filter = (Filter)this.context.getInstanceManager().newInstance(string);
        this.initFilter();
        return this.filter;
    }

    private void initFilter() throws ServletException {
        if (this.context instanceof StandardContext && this.context.getSwallowOutput()) {
            try {
                SystemLogHandler.startCapture();
                this.filter.init((FilterConfig)this);
            }
            finally {
                String string = SystemLogHandler.stopCapture();
                if (string != null && !string.isEmpty()) {
                    this.getServletContext().log(string);
                }
            }
        } else {
            this.filter.init((FilterConfig)this);
        }
        this.registerJMX();
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    void release() {
        this.unregisterJMX();
        if (this.filter != null) {
            block10: {
                try {
                    if (Globals.IS_SECURITY_ENABLED) {
                        try {
                            SecurityUtil.doAsPrivilege("destroy", this.filter);
                            break block10;
                        }
                        finally {
                            SecurityUtil.remove(this.filter);
                        }
                    }
                    this.filter.destroy();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.context.getLogger().error((Object)sm.getString("applicationFilterConfig.release", new Object[]{this.filterDef.getFilterName(), this.filterDef.getFilterClass()}), throwable);
                }
            }
            if (!this.context.getIgnoreAnnotations()) {
                try {
                    this.context.getInstanceManager().destroyInstance((Object)this.filter);
                }
                catch (Exception exception) {
                    Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)exception);
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.context.getLogger().error((Object)sm.getString("applicationFilterConfig.preDestroy", new Object[]{this.filterDef.getFilterName(), this.filterDef.getFilterClass()}), throwable);
                }
            }
        }
        this.filter = null;
    }

    private void registerJMX() {
        String string;
        String string2;
        Object object = this.context.getName();
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        string2 = (string2 = this.context.getParent().getName()) == null ? "DEFAULT" : string2;
        String string3 = this.context.getParent().getParent().getName();
        String string4 = "//" + string2 + (String)object;
        String string5 = this.filterDef.getFilterName();
        if (Util.objectNameValueNeedsQuote((String)string5)) {
            string5 = ObjectName.quote(string5);
        }
        if (this.context instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)this.context;
            string = string3 + ":j2eeType=Filter,WebModule=" + string4 + ",name=" + string5 + ",J2EEApplication=" + standardContext.getJ2EEApplication() + ",J2EEServer=" + standardContext.getJ2EEServer();
        } else {
            string = string3 + ":j2eeType=Filter,name=" + string5 + ",WebModule=" + string4;
        }
        try {
            this.oname = new ObjectName(string);
            Registry.getRegistry(null).registerComponent((Object)this, this.oname, null);
        }
        catch (Exception exception) {
            this.log.warn((Object)sm.getString("applicationFilterConfig.jmxRegisterFail", new Object[]{this.getFilterClass(), this.getFilterName()}), (Throwable)exception);
        }
    }

    private void unregisterJMX() {
        if (this.oname != null) {
            try {
                Registry.getRegistry(null).unregisterComponent(this.oname);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("applicationFilterConfig.jmxUnregister", new Object[]{this.getFilterClass(), this.getFilterName()}));
                }
            }
            catch (Exception exception) {
                this.log.warn((Object)sm.getString("applicationFilterConfig.jmxUnregisterFail", new Object[]{this.getFilterClass(), this.getFilterName()}), (Throwable)exception);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog(ApplicationFilterConfig.class);
    }
}

