# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestCaseStarted message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class TestCaseStarted < Message
      ##
      # The first attempt should have value 0, and for each retry the value
      # should increase by 1.
      ##
      attr_reader :attempt

      ##
      # Because a `TestCase` can be run multiple times (in case of a retry),
      # we use this field to group messages relating to the same attempt.
      ##
      attr_reader :id

      attr_reader :test_case_id

      ##
      # An identifier for the worker process running this test case, if test cases are being run in parallel. The identifier will be unique per worker, but no particular format is defined - it could be an index, uuid, machine name etc - and as such should be assumed that it's not human readable.
      ##
      attr_reader :worker_id

      attr_reader :timestamp

      def initialize(
        attempt: 0,
        id: '',
        test_case_id: '',
        worker_id: nil,
        timestamp: Timestamp.new
      )
        @attempt = attempt
        @id = id
        @test_case_id = test_case_id
        @worker_id = worker_id
        @timestamp = timestamp
        super()
      end

      ##
      # Returns a new TestCaseStarted from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestCaseStarted.from_h(some_hash) # => #<Cucumber::Messages::TestCaseStarted:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          attempt: hash[:attempt],
          id: hash[:id],
          test_case_id: hash[:testCaseId],
          worker_id: hash[:workerId],
          timestamp: Timestamp.from_h(hash[:timestamp])
        )
      end
    end
  end
end
